package cn.com.duiba.creditsclub.ecosphere.sdk.utils;

import cn.com.duiba.creditsclub.ecosphere.sdk.Api;
import cn.com.duiba.creditsclub.ecosphere.sdk.data.Option;
import cn.com.duiba.creditsclub.ecosphere.sdk.data.UserPrizeRecord;
import cn.com.duiba.creditsclub.ecosphere.sdk.playway.base.Prize;
import cn.com.duiba.creditsclub.ecosphere.sdk.playway.base.PrizeStock;
import cn.com.duiba.creditsclub.ecosphere.sdk.playway.base.UserData;

import java.security.KeyStore;
import java.util.List;
import java.util.Map;

public interface ProjectApi extends Api {

    PrizeStock getPrizeStock(String prizeId);

    /**
     * 批量获取奖品库存信息
     *
     * @param ids prize ids
     * @return prize stock list
     */
    List<PrizeStock> listPrizeStock(List<String> ids);

    Prize getPrize(String prizeId);

    /**
     * 批量查询奖品信息
     *
     * @param prizeIds
     * @return
     */
    List<Prize> getPrizes(List<String> prizeIds);

    /**
     * 给用户发放道具
     *
     * @param userId   userId
     * @param spId     道具ID
     * @param quantity 道具个数
     * @return 记录ID
     */
    Long giveStageProperty(String userId, String spId, int quantity);


    /**
     * 获取一个http请求实例,不同project之间相互隔离
     *
     * @return
     */
    HttpHelper getHttpHelper();

    /**
     * 获取异步http请求实例
     * @return
     */
    HttpAsyncClient getHttpAsyncClient();

    /**
     * 获取一个https请求实例
     *
     * @param name     实例的名称，不同实例间隔离
     * @param keyStore 证书
     * @return
     */
    HttpHelper getHttpHelper(String name, KeyStore keyStore);

    /**
     * 消耗某个用户的道具
     *
     * @param userId   userId
     * @param spId     spId
     * @param quantity 数量
     * @return 消耗是否成功
     */
    Boolean consumeStageProperty(String userId, String spId, int quantity);

    /**
     * 查询某人所有的道具的数量信息
     *
     * @param userId 需要查询的用户
     * @return key:道具id，value:拥有的道具数
     */
    Map<String, Long> getSomebodyAllStageProperty(String userId);

    /**
     * 查询某人的某个道具的数量
     *
     * @param userId 需要查询的用户
     * @param spId   道具id
     * @return
     */
    Long getSomebodyStageProperty(String userId, String spId);

    /**
     * 获取某个发奖策略下面的奖项列表
     *
     * @param strategyId 发奖策略id
     * @return list
     */
    List<Option> queryOptions(String strategyId);

    /**
     * list user data
     * user id 的个数不能超过500个，超过会抛异常
     *
     * @param key     key
     * @param userIds user ids
     * @return user data list
     */
    List<UserData> batchListUserData(String key, List<String> userIds);

    /**
     * 判断某个用户是否是开发者白名单用户
     *
     * @param partnerUserId
     * @param projectId
     * @return user data list
     */
    Boolean isWhiteListUser(String partnerUserId, String projectId);

    /**
     * 获取当前用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     *
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @return
     */
    List<UserPrizeRecord> listUserPrizeRecord(boolean ignoreAddCredits);

    /**
     * 获取制定用户中奖纪录列表
     * 本接口只查询数据库中最近的1000条纪录，并对其中的加积分奖品进行筛选或不筛选
     *
     * @param userId           用户ID
     * @param ignoreAddCredits 是否忽略加积分奖品   true: 忽略  false:不忽略
     * @return
     */
    List<UserPrizeRecord> listSomebodyUserPrizeRecord(String userId, boolean ignoreAddCredits);


}
