package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.boot.utils.SpringEnvironmentUtils;
import cn.com.duiba.credits.sdk.AssembleTool;
import cn.com.duiba.credits.sdk.CreditTool;
import cn.com.duiba.customer.link.sdk.project.ProjectInfoUtil;
import cn.com.duiba.customer.link.sdk.project.ProjectRuntimeException;
import cn.com.duiba.developer.center.api.domain.dto.AppSimpleDto;
import cn.com.duiba.developer.center.api.remoteservice.RemoteAppService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 * 免登工具
 *
 * @author 刘佳辉
 * @since 2022/9/14
 */
@Component
@Valid
public class DuibaLoginUtil {

    @Resource
    private RemoteAppService appInfoCacheService;


    public String generateAutoLoginUrl(HttpServletRequest request,
                                       String projectId,
                                       Long appId,
                                       String uid,
                                       String credits,
                                       String dcustom,
                                       Map<String, String> appendParams) {

        // 默认跳转首页
        String dbRedirectUrl = getDBRedirectUrl(projectId, request);
        Map<String, String> params = new TreeMap<>();
        params.put("uid", uid);
        params.put("credits", credits);
        params.put("dcustom", dcustom);
        params.put("redirect", AssembleTool.assembleUrl(dbRedirectUrl, appendParams));
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));

        try {
            AppSimpleDto appSimpleDto = appInfoCacheService.getSimpleApp(appId).getResult();
            return new CreditTool(appSimpleDto.getAppKey(), appSimpleDto.getAppSecret()).buildUrlWithSign(getLoginRequestUrl(), params);
        } catch (Exception e) {
            throw new ProjectRuntimeException("创建免登连接失败{}", e);
        }
    }


    public String generateAutoLoginUrl(@NotNull String projectId,
                                       @NotNull Long appId,
                                       @NotNull String uid,
                                       @NotNull String credits,
                                       @NotNull String dcustom,
                                       @NotNull Map<String, String> appendParams) {
        return generateAutoLoginUrl(null, projectId, appId, uid, credits, dcustom, appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId,
                                       @NotNull String uid,
                                       @NotNull String credits,
                                       @NotNull String dcustom,
                                       @NotNull Map<String, String> appendParams) {
        return generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, credits, dcustom, appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId,
                                       @NotNull String uid,
                                       @NotNull String dcustom,
                                       @NotNull Map<String, String> appendParams) {
        return generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, "", dcustom, appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId,
                                       @NotNull String uid,
                                       @NotNull Map<String, String> appendParams) {
        return generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, "", "", appendParams);
    }

    public String generateAutoLoginUrl(@NotNull String projectId,
                                       @NotNull String uid) {
        return generateAutoLoginUrl(null, projectId, ProjectInfoUtil.getAppId(), uid, "", "", new HashMap<>());
    }

    private String getLoginRequestUrl() {
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "https://activity.m.duibadev.com.cn/autoLogin/autologin?";
        } else if (SpringEnvironmentUtils.isTestEnv()) {
            return "https://activity.m.duibatest.com.cn/autoLogin/autologin?";
        } else if (SpringEnvironmentUtils.isProdEnv()) {
            return "https://activity.m.duiba.com.cn/autoLogin/autologin?";
        }
        throw new RuntimeException("获取免登请求连接错误，环境错误");
    }


    private String getDBRedirectUrl(String projectXId, HttpServletRequest request) {
        if (request != null && StringUtils.isNoneBlank(request.getParameter("dbredirect"))) {
            return request.getParameter("dbredirect");
        }
        if (SpringEnvironmentUtils.isDevEnv()) {
            return "http://activity.m.duibadev.com.cn/projectx/" + projectXId + "/index.html";
        } else if (SpringEnvironmentUtils.isTestEnv()) {
            return "http://activity.m.duibatest.com.cn/projectx/" + projectXId + "/index.html";
        } else if (SpringEnvironmentUtils.isProdEnv()) {
            return "http://activity.m.duiba.com.cn/projectx/" + projectXId + "/index.html";
        }
        throw new RuntimeException("获取免登跳转连接错误，环境错误");
    }

}
