package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.customer.link.sdk.http.DefaultHttpHelper;
import cn.com.duiba.customer.link.sdk.http.HttpClientBuilder;
import cn.com.duiba.customer.link.sdk.project.ProjectInfoUtil;
import org.springframework.stereotype.Component;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

/**
 * 星速台请求工具
 *
 * @author 刘佳辉
 * @since 2022/10/14
 */
@Component
public class ProjectXRequestUtil {


    private final String projectXService = "http://projectx-gateway/projectx/";

    /**
     * 同步请求 星速台
     *
     * @param projectXProjectId 星速台项目id ：p4162cd33
     * @param activityUrl       活动地址 ：/action/prize.do
     * @param uriVariables      参数
     */
    public String syncRequest(String projectXProjectId, String activityUrl, Map<String, String> uriVariables) {
        DefaultHttpHelper httpHelper = getHttpHelper();

        String url = projectXService + projectXProjectId + activityUrl;
        return httpHelper.doPostUseTemplate(url, uriVariables);
    }

    /**
     * 异步请求 星速台
     *
     * @param projectXProjectId 星速台项目id ：p4162cd33
     * @param activityUrl       活动地址 ：/action/prize.do
     * @param uriVariables      参数
     */
    public void asyncRequest(String projectXProjectId, String activityUrl, Map<String, String> uriVariables) {

        DefaultHttpHelper httpHelper = getHttpHelper();

        ExecutorService threadPool = httpHelper.getThreadPool();
        String url = projectXService + projectXProjectId + activityUrl;
        CompletableFuture.runAsync(() -> {
            httpHelper.doPostUseTemplate(url, uriVariables);
        }, threadPool);
    }

    private DefaultHttpHelper getHttpHelper() {
        Long appId = Optional.ofNullable(ProjectInfoUtil.getAppId()).orElse(0L);
        String beanName = "consumer-" + appId;
        return new DefaultHttpHelper(HttpClientBuilder.createHttpClient(beanName));
    }

}
