package cn.com.duiba.customer.link.sdk;

import org.jetbrains.annotations.NotNull;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;


@Component
public class SpringBeanFactory implements ApplicationContextAware {

    private static ApplicationContext applicationContext;

    @Override
    public void setApplicationContext(@NotNull ApplicationContext applicationContext) throws BeansException {
        SpringBeanFactory.applicationContext = applicationContext;
    }

    public static Object getBean(String beanName) {
        if (applicationContext == null) {
            throw new RuntimeException("获取bean异常：" + beanName);
        }
        return applicationContext.getBean(beanName);
    }

    public static <T> T getBean(Class<T> beanType) {
        if (applicationContext == null) {
            throw new RuntimeException("获取bean异常：" + beanType.getName());
        }
        return applicationContext.getBean(beanType);
    }

    public static <T> T getBean(Class<T> beanType, Object... args) {
        if (applicationContext == null) {
            throw new RuntimeException("获取bean异常：" + beanType.getName());
        }
        return applicationContext.getBean(beanType, args);
    }

    public static ApplicationContext getApplicationContext() {
        return applicationContext;
    }

}
