package cn.com.duiba.customer.link.sdk.config;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Configuration
@ConfigurationProperties("inner.path")
public class InnerPathConfiguration implements InitializingBean {
    /**
     * http内网调用配置映射
     */
    private String urlPathMapping;

    private Map<String, String> urlPathMappingMap = MapUtils.EMPTY_MAP;

    public String getUrlPathMapping() {
        return urlPathMapping;
    }

    public void setUrlPathMapping(String urlPathMapping) {
        this.urlPathMapping = urlPathMapping;
    }

    public Map<String, String> getUrlPathMappingMap() {
        return urlPathMappingMap;
    }

    public void setUrlPathMappingMap(Map<String, String> urlPathMappingMap) {
        this.urlPathMappingMap = urlPathMappingMap;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (StringUtils.isBlank(urlPathMapping)) {
            return;
        }

        List<UrlMapping> urlPathMappingList = JSONObject.parseArray(urlPathMapping.trim(), UrlMapping.class);
        if (CollectionUtils.isNotEmpty(urlPathMappingList)) {
            urlPathMappingMap = urlPathMappingList.stream().filter(urlMappingParam -> StringUtils.isNotBlank(urlMappingParam.getUrlPath())).collect(Collectors.toMap(UrlMapping::getUrlPath, UrlMapping::getAppName, (old, newa) -> newa));
        }
    }


    public static class UrlMapping {

        /**
         * request url path
         */
        private String urlPath;

        /**
         * app name
         */
        private String appName;

        public String getUrlPath() {
            return urlPath;
        }

        public void setUrlPath(String urlPath) {
            this.urlPath = urlPath;
        }

        public String getAppName() {
            return appName;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }
    }
}
