package cn.com.duiba.customer.link.sdk.project;


/**
 * 项目运行异常
 */
public class ProjectRuntimeException extends RuntimeException {


    private String code = "0";

    /**
     * 是否需要warn级别日志输出
     * ⚠️ 默认是不输出
     */
    private boolean outWarnLog = false;

    public ProjectRuntimeException(String message) {
        super(message);
    }

    public ProjectRuntimeException(String message, boolean outWarnLog) {
        super(message);
        this.outWarnLog = outWarnLog;
    }


    public ProjectRuntimeException(String code, String message) {
        super(message);
        this.code = code;
    }

    public ProjectRuntimeException(String code, String message, boolean outWarnLog) {
        super(message);
        this.code = code;
        this.outWarnLog = outWarnLog;
    }

    public ProjectRuntimeException(String code, String message, Throwable cause) {
        super(message, cause);
        this.code = code;
    }

    public ProjectRuntimeException(String code, String message, Throwable cause, boolean outWarnLog) {
        super(message, cause);
        this.code = code;
        this.outWarnLog = outWarnLog;
    }

    public ProjectRuntimeException(String message, Throwable cause) {
        super(message, cause);
    }

    public ProjectRuntimeException(String message, Throwable cause, boolean outWarnLog) {
        super(message, cause);
        this.outWarnLog = outWarnLog;
    }

    public ProjectRuntimeException(Throwable cause) {
        super(cause);
    }

    public ProjectRuntimeException(Throwable cause, boolean outWarnLog) {
        super(cause);
        this.outWarnLog = outWarnLog;
    }

    public String getCode() {
        return code;
    }

    public boolean isOutWarnLog() {
        return outWarnLog;
    }

}
