/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.customer.link.sdk.http.DefaultHttpHelper;
import cn.com.duiba.customer.link.sdk.http.HttpClientBuilder;
import cn.com.duiba.customer.link.sdk.project.ProjectInfoUtil;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.springframework.stereotype.Component;

@Component
public class ProjectXRequestUtil {
    private final String projectXService = "http://projectx-gateway/projectx/";

    public String syncRequest(String projectXProjectId, String activityUrl, Map<String, String> uriVariables) {
        DefaultHttpHelper httpHelper = this.getHttpHelper();
        String url = "http://projectx-gateway/projectx/" + projectXProjectId + activityUrl;
        return httpHelper.doPostUseTemplate(url, uriVariables);
    }

    public void asyncRequest(String projectXProjectId, String activityUrl, Map<String, String> uriVariables) {
        DefaultHttpHelper httpHelper = this.getHttpHelper();
        ExecutorService threadPool = httpHelper.getThreadPool();
        String url = "http://projectx-gateway/projectx/" + projectXProjectId + activityUrl;
        CompletableFuture.runAsync(() -> httpHelper.doPostUseTemplate(url, uriVariables), threadPool);
    }

    private DefaultHttpHelper getHttpHelper() {
        Long appId = Optional.ofNullable(ProjectInfoUtil.getAppId()).orElse(0L);
        String beanName = "consumer-" + appId;
        return new DefaultHttpHelper(HttpClientBuilder.createHttpClient(beanName));
    }
}

