/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk;

import cn.com.duiba.customer.link.sdk.SpringBeanFactory;
import cn.com.duiba.customer.link.sdk.project.ProjectInfoUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.data.redis.connection.StringRedisConnection;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.TimeoutUtils;

public class RedisApi {
    private StringRedisTemplate stringRedisTemplate;
    private Long projectId;
    public static final String KEY_PREFIX = "customer-link:";
    private static final long TIME_OUT = 189216000L;

    private RedisApi() {
    }

    private RedisApi(Long projectId) {
        this.projectId = projectId;
        this.stringRedisTemplate = SpringBeanFactory.getBean(StringRedisTemplate.class);
    }

    public static RedisApi create() {
        return new RedisApi(ProjectInfoUtil.getAppId());
    }

    public String makeKey(String key) {
        return KEY_PREFIX + this.projectId + ":" + key;
    }

    public void set(String key, String value, long l, TimeUnit timeUnit) {
        this.stringRedisTemplate.opsForValue().set((Object)this.makeKey(key), (Object)value, l, timeUnit);
    }

    public String get(String key) {
        return (String)this.stringRedisTemplate.opsForValue().get((Object)this.makeKey(key));
    }

    public Long increment(String key, long offset, Long timeOut, TimeUnit timeUnit) {
        List pipelined = this.stringRedisTemplate.executePipelined(connection -> {
            StringRedisConnection conn = (StringRedisConnection)connection;
            conn.incrBy(this.makeKey(key), offset);
            this.toExpire(key, timeOut, timeUnit, conn);
            return null;
        });
        return Long.parseLong(pipelined.get(0).toString());
    }

    private void toExpire(String key, Long timeOut, TimeUnit timeUnit, StringRedisConnection conn) {
        if (ObjectUtils.allNotNull((Object[])new Object[]{timeOut, timeUnit})) {
            long rawTimeout = TimeoutUtils.toSeconds((long)timeOut, (TimeUnit)timeUnit);
            conn.expire(this.makeKey(key), rawTimeout);
        } else {
            conn.expire(this.makeKey(key), 189216000L);
        }
    }

    public StringRedisTemplate getStringRedisTemplate() {
        return this.stringRedisTemplate;
    }
}

