/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk.http;

import cn.com.duiba.customer.link.sdk.SpringBeanFactory;
import cn.com.duiba.customer.link.sdk.http.HttpHelper;
import cn.com.duiba.wolf.utils.UrlUtils2;
import com.alibaba.fastjson.JSON;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.collections.MapUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.web.client.RestTemplate;

public class DefaultHttpHelper
implements HttpHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHttpHelper.class);
    private CloseableHttpClient httpClient;
    private RestTemplate businessRestTemplate;
    private final ExecutorService threadPool = Executors.newFixedThreadPool(4);

    public ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public DefaultHttpHelper(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        this.businessRestTemplate = (RestTemplate)SpringBeanFactory.getBean("businessRestTemplate");
    }

    @Override
    public String doGet(String url, Map<String, String> uriVariables) {
        if (MapUtils.isNotEmpty(uriVariables)) {
            url = UrlUtils2.appendParams((String)url, uriVariables);
        }
        return this.execute((HttpUriRequest)new HttpGet(url));
    }

    @Override
    public <T> T doGet(String url, Map<String, String> uriVariables, Class<T> responseType) {
        String response = this.doGet(url, uriVariables);
        if (response == null) {
            return null;
        }
        return (T)JSON.parseObject((String)response, responseType);
    }

    @Override
    public String doGet(String url, Map<String, String> uriVariables, Header header) {
        String fullUrl = url;
        if (MapUtils.isNotEmpty(uriVariables)) {
            fullUrl = UrlUtils2.appendParams((String)url, uriVariables);
        }
        HttpGet httpGet = new HttpGet(fullUrl);
        httpGet.setHeader(header);
        return this.execute((HttpUriRequest)httpGet);
    }

    @Override
    public String doPost(String url, Map<String, String> uriVariables) {
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> list = new ArrayList<BasicNameValuePair>();
        if (MapUtils.isNotEmpty(uriVariables)) {
            for (Map.Entry<String, String> entry : uriVariables.entrySet()) {
                list.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(list, Charset.defaultCharset());
        httpPost.setEntity((HttpEntity)formEntity);
        return this.execute((HttpUriRequest)httpPost);
    }

    public String doPostUseTemplate(String url, Map<String, String> uriVariables) {
        try {
            ResponseEntity responseEntity;
            LinkedMultiValueMap map = new LinkedMultiValueMap();
            if (MapUtils.isNotEmpty(uriVariables)) {
                for (Map.Entry<String, String> entry : uriVariables.entrySet()) {
                    map.add((Object)entry.getKey(), (Object)entry.getValue());
                }
            }
            if ((responseEntity = this.businessRestTemplate.postForEntity(url, (Object)map, String.class, new Object[0])).getStatusCode() != HttpStatus.OK) {
                throw new RuntimeException("loadBalance\u8c03\u7528\u5931\u8d25, code:" + responseEntity.getStatusCode());
            }
            return (String)responseEntity.getBody();
        }
        catch (Exception e) {
            LOGGER.warn("loadBalance\u8c03\u7528\u5931\u8d25,url={},insideCallUrl={}", new Object[]{url, url, e});
            throw new RuntimeException("loadBalance\u8c03\u7528\u5931\u8d25", e);
        }
    }

    @Override
    public <T> T doPost(String url, Map<String, String> uriVariables, Class<T> responseType) {
        String response = this.doPost(url, uriVariables);
        if (response == null) {
            return null;
        }
        return (T)JSON.parseObject((String)response, responseType);
    }

    @Override
    public String doPost(String url, Header header, HttpEntity httpEntity) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeader(header);
        httpPost.setEntity(httpEntity);
        return this.execute((HttpUriRequest)httpPost);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String execute(HttpUriRequest httpUriRequest) {
        try (CloseableHttpResponse response = this.httpClient.execute(httpUriRequest);){
            if (response.getStatusLine().getStatusCode() == 200) {
                String string = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                return string;
            }
            LOGGER.warn("\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25:url={}, code={}", (Object)(httpUriRequest.getURI().getHost() + httpUriRequest.getURI().getPath()), (Object)response.getStatusLine().getStatusCode());
            throw new RuntimeException("\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25:" + response.getStatusLine().getStatusCode());
        }
        catch (Exception e) {
            LOGGER.warn("\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25\uff1aurl={}", (Object)(httpUriRequest.getURI().getHost() + httpUriRequest.getURI().getPath()), (Object)e);
            throw new RuntimeException("\u8bf7\u6c42\u63a5\u53e3\u5931\u8d25", e);
        }
    }

    @Override
    public String executeGet(String url, Map<String, String> uriVariables, Header[] headers) {
        String fullUrl = url;
        if (MapUtils.isNotEmpty(uriVariables)) {
            fullUrl = UrlUtils2.appendParams((String)url, uriVariables);
        }
        HttpGet httpGet = new HttpGet(fullUrl);
        httpGet.setHeaders(headers);
        return this.execute((HttpUriRequest)httpGet);
    }

    @Override
    public String executePost(String url, Header[] headers, HttpEntity httpEntity) {
        HttpPost httpPost = new HttpPost(url);
        httpPost.setHeaders(headers);
        httpPost.setEntity(httpEntity);
        return this.execute((HttpUriRequest)httpPost);
    }
}

