/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.customer.link.sdk.http;

import cn.com.duiba.customer.link.sdk.SpringBeanFactory;
import cn.com.duiba.customer.link.sdk.http.HttpClientFactoryBean;
import java.security.KeyStore;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class HttpClientBuilder {
    public static CloseableHttpClient createHttpClient(String beanName) {
        return HttpClientBuilder.createHttpClient(null, beanName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseableHttpClient createHttpClient(KeyStore keyStore, String beanName) {
        ApplicationContext applicationContext = SpringBeanFactory.getApplicationContext();
        CloseableHttpClient httpClient = HttpClientBuilder.getBeanWithoutException(beanName, applicationContext);
        if (httpClient != null) {
            return httpClient;
        }
        String string = beanName.intern();
        synchronized (string) {
            httpClient = HttpClientBuilder.getBeanWithoutException(beanName, applicationContext);
            if (httpClient != null) {
                return httpClient;
            }
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(HttpClientFactoryBean.class);
            builder.addPropertyValue("keyStore", (Object)keyStore);
            builder.addPropertyValue("applicationContext", (Object)applicationContext);
            AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)((AbstractApplicationContext)applicationContext).getBeanFactory();
            beanFactory.registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            httpClient = (CloseableHttpClient)SpringBeanFactory.getBean(beanName);
        }
        return httpClient;
    }

    private static CloseableHttpClient getBeanWithoutException(String beanName, ApplicationContext applicationContext) {
        try {
            Object bean = applicationContext.getBean(beanName);
            return (CloseableHttpClient)bean;
        }
        catch (BeansException beansException) {
            return null;
        }
    }
}

