package cn.com.duiba.customer.link.project.api.remoteservice.app70398.vo;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * @description: 中信开放银行公共入参
 * @author LiJiang
 * @date 2022/11/21
 **/
public class CiticCustomerBaseVO {

    /**
     * 开放平台接口版本号 默认填写1.0.0
     */
    @JSONField(name = "OPENVER")
    private String openVersion;

    /**
     * 开放平台接口码
     */
    @JSONField(name = "OPENTRANSCODE")
    private String openTransCode;

    /**
     * 开放平台商户号
     */
    @JSONField(name = "OPENMERCODE")
    private String openMerchantCode;

    /**
     * 开放平台商户名称
     */
    @JSONField(name = "OPENMERNAME")
    private String openMerchantName;

    /**
     * 商户业务类型
     */
    @JSONField(name = "OPENBUSITYPE")
    private String openBusinessType;

    /**
     * 商户交易发起日期 YYYYMMDD
     */
    @JSONField(name = "OPENLAUNCHDATE")
    private String openLaunchDate;

    /**
     * 商户交易发起时间 HHMMSS
     */
    @JSONField(name = "OPENLAUNCHTIME")
    private String openLaunchTime;


    /**
     * 商户请求流水号
     * 能唯一标识一笔交易。建议按以下构成：合作方自定义部分（如合作方英文缩写、对应业务缩写等，12位）+YYYYMMDDHHmmss+6位随机序列
     */
    @JSONField(name = "OPENMERFLOWID")
    private String openMerchantFlowId;


    public String getOpenVersion() {
        return openVersion;
    }

    public void setOpenVersion(String openVersion) {
        this.openVersion = openVersion;
    }

    public String getOpenTransCode() {
        return openTransCode;
    }

    public void setOpenTransCode(String openTransCode) {
        this.openTransCode = openTransCode;
    }

    public String getOpenMerchantCode() {
        return openMerchantCode;
    }

    public void setOpenMerchantCode(String openMerchantCode) {
        this.openMerchantCode = openMerchantCode;
    }

    public String getOpenMerchantName() {
        return openMerchantName;
    }

    public void setOpenMerchantName(String openMerchantName) {
        this.openMerchantName = openMerchantName;
    }

    public String getOpenBusinessType() {
        return openBusinessType;
    }

    public void setOpenBusinessType(String openBusinessType) {
        this.openBusinessType = openBusinessType;
    }

    public String getOpenLaunchDate() {
        return openLaunchDate;
    }

    public void setOpenLaunchDate(String openLaunchDate) {
        this.openLaunchDate = openLaunchDate;
    }

    public String getOpenLaunchTime() {
        return openLaunchTime;
    }

    public void setOpenLaunchTime(String openLaunchTime) {
        this.openLaunchTime = openLaunchTime;
    }

    public String getOpenMerchantFlowId() {
        return openMerchantFlowId;
    }

    public void setOpenMerchantFlowId(String openMerchantFlowId) {
        this.openMerchantFlowId = openMerchantFlowId;
    }
}
