package cn.com.duiba.customer.link.project.api.remoteservice.app90529.dto;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;

/**
 * write_your_class_description_here
 *
 * @author xulei
 * @since 1.0.0
 */
public class SendTemplateMessageDTO {

    /**
     * 填接收消息的用户openid
     */
    private String touser;

    /**
     * 订阅消息模板ID
     */
    @JSONField(name = "template_id")
    private String templateId;

    /**
     * 点击消息跳转的链接, 需要有ICP备案(路径必须和填写的业务域名相同)
     */
    private String url;

    /**
     * 跳小程序所需数据, 不需跳小程序可不用传该数据
     */
    @JSONField(name = "miniprogram")
    private JSONObject miniProgram;

    /**
     * 所需跳转到的小程序appid(该小程序appid必须与发模板消息的公众号是绑定关联关系, 并且小程序要求是已发布的)
     */
    private String appid;

    /**
     * 所需跳转到小程序的具体页面路径, 支持带参数,(示例index?foo=bar)
     */
    @JSONField(name = "pagepath")
    private String pagePath;

    /**
     * 场景值
     */
    private String scene;

    /**
     * 订阅场景值, 消息标题, 15字以内
     */
    private String title;

    /**
     * 消息正文, value为消息内容文本(200字以内), 没有固定格式, 可用\n换行, color为整段消息内容的字体颜色(目前仅支持整段消息为一种颜色)
     */
    private JSONObject data;

    public String getTouser() {
        return touser;
    }

    public void setTouser(String touser) {
        this.touser = touser;
    }

    public String getTemplateId() {
        return templateId;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public JSONObject getMiniProgram() {
        return miniProgram;
    }

    public void setMiniProgram(JSONObject miniProgram) {
        this.miniProgram = miniProgram;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getPagePath() {
        return pagePath;
    }

    public void setPagePath(String pagePath) {
        this.pagePath = pagePath;
    }

    public String getScene() {
        return scene;
    }

    public void setScene(String scene) {
        this.scene = scene;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public JSONObject getData() {
        return data;
    }

    public void setData(JSONObject data) {
        this.data = data;
    }
}
