package cn.com.duiba.customer.link.project.api.remoteservice.app92059;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.dto.JiKeAccountDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.dto.JiKeConsumeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.dto.JiKeDeviceInfoDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.dto.JiKeProduceDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.vo.JiKeAccountVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.vo.JiKeApiResult;
import cn.com.duiba.customer.link.project.api.remoteservice.app92059.vo.JieKeDeviceInfoVO;


/**
 * @author LiJiang
 * @description 极氪汽车-世界杯
 * @date 2022/11/5
 */
public interface RemoteJiKeCar {
    /**
     * 000000 	成功
     * 999999 	业务异常
     * 200100	账户不存在
     * 用户极分-查询
     *
     * @param jiKeAccountDTO jiKeAccountDTO
     * @return JiKeAccountVO
     */
    JiKeApiResult<JiKeAccountVO> account(JiKeAccountDTO jiKeAccountDTO) throws BizException;

    /**
     * 000000 	成功
     * 999999 	业务异常
     * 200100	账户不存在
     * 100010	无该编码的事件
     * 100000	极分不足
     * 100002	已无可用极分
     * 100031	积分参数-source的子极分之和和总计分值不一样
     * 100021	已存在该条消费记录
     * 用户极分-消费
     *
     * @param consumeDTO consumeDTO
     * @return JiKeAccountVO
     */
    JiKeApiResult<Boolean> consume(JiKeConsumeDTO consumeDTO) throws BizException;

    /**
     * 000000 	成功
     * 999999 	业务异常
     * 200100	账户不存在
     * 100010	无该编码的事件
     * 100022	已存在该条发放记录
     * 用户极分-发放
     *
     * @param produceDTO consumeDTO
     * @return JiKeAccountVO
     */
    JiKeApiResult<Boolean> produce(JiKeProduceDTO produceDTO) throws BizException;


    /**
     * 查询用户关联的设备信息 <br>
     * Note: 用户未登录或异常返回空
     *
     * @param dto 查询设备信息dto
     * @return 用户关联的设备信息
     */
    JiKeApiResult<JieKeDeviceInfoVO> deviceInfo(JiKeDeviceInfoDTO dto) throws BizException;
}
