package cn.com.duiba.customer.link.project.api.remoteservice.app69607;

import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.ChangeUrlDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.GetShareCodeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.GetTaskStatusDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.QueryGoodsDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.QueryNearShopDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.ScanImgDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.SendMsgDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.dto.SendPrizeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.vo.DistributorInfoVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.vo.GoodsListVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.vo.NearShopResultVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.vo.ScanImgResultVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app69607.vo.TaskStatusVO;
import java.util.List;

/**
 * @author zht
 * @description 滔搏接口
 * @createTime 2022年11月30日
 */
public interface RemoteTaoBo {

    /**
     * 发放奖品接口
     * @param dto
     * @return 是否发送成功
     */
    void sendPrize(SendPrizeDTO dto);

    /**
     * 发送消息通知
     * @param dto
     * @return 是否发送成功
     */
    void sendMsg(List<SendMsgDTO> dto);

    /**
     * 查询任务完成状态
     * @param dto
     * @return
     */
    List<TaskStatusVO> getTaskStatus(GetTaskStatusDTO dto);

    /**
     * 查询分销员编号和门店编码
     * @param memberId
     * @return
     */
    DistributorInfoVO getDistributorInfo(String memberId);

    /**
     * 查询附近门店
     * @param dto
     * @return
     */
    NearShopResultVO getNearShop(QueryNearShopDTO dto);

    /**
     * 活动图识别
     * @param dto
     * @return
     */
    ScanImgResultVO scanImg(ScanImgDTO dto);

    /**
     * 商品列表瀑布分页查询
     * @param dto
     * @return
     */
    GoodsListVO getGoodsList(QueryGoodsDTO dto);

    /**
     * 获取小程序太阳码
     * @param dto
     * @return
     */
    String getShareCode(GetShareCodeDTO dto);

    /**
     * 长链接转短链接
     * @param url
     * @return
     */
    String changeUrlShort(ChangeUrlDTO url);
}
