package cn.com.duiba.customer.link.project.api.remoteservice.app86672;


import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.EtcQueryParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.EtcResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.QueryClubParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.SendImParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.StepBatchQueryParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.StepDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.dto.StepQueryParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app86672.vo.Result;

import java.util.List;

/**
 * 长城魏牌接口
 *
 * @author songp
 * @date 2023/3/16 3:31 PM
 */
public interface RemoteChangChengWey {

    /**
     * 根据用户id查询俱乐部名称列表
     *
     * @param queryClubParam 请求入参
     * @return 俱乐部名称列表,返回null表示接口异常
     */
    Result<List<String>> getBoardNameByUserId(QueryClubParam queryClubParam);

    /**
     * wey 碳公益活动单发IM私信
     *
     * @param sendImParam 请求入参
     * @return 私信是否发送成功-为true是
     */
    Result<Boolean> sendIMByCarbonOffsetActivities(SendImParam sendImParam);

    /**
     * 分页查询指定品牌车辆用户每日新增ETC使用次数统计信息
     *
     * @param etcQueryParam 请求入参
     * @return 账单列表,返回null表示接口异常
     */
    Result<EtcResultDto> queryEtcBill(EtcQueryParam etcQueryParam);

    /**
     * 查询碳行动步数
     *
     * @param stepQueryParam 请求入参
     * @return 步数集合,返回null表示接口异常
     */
    Result<StepDto> getStep(StepQueryParam stepQueryParam);

    /**
     * 批量查询碳行动步数
     *
     * @param stepQueryParam 请求入参
     * @return 步数集合,返回null表示接口异常
     */
    Result<List<StepDto>> getStepList(StepBatchQueryParam stepQueryParam);

}
