package cn.com.duiba.customer.link.project.api.remoteservice.app87436;

import cn.com.duiba.customer.link.project.api.remoteservice.app87436.dto.PrizeQueryParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app87436.vo.AutoLoginResult;
import cn.com.duiba.customer.link.project.api.remoteservice.app87436.vo.OrderQueryResult;

public interface RemoteChongQingBank {

    /**
     * 根据手机号生成免登地址
     *
     * @param phone    手机号（必传）
     * @param redirect 重定向地址（比传）
     * @return 免登地址，null表示失败
     */
    AutoLoginResult genAutoLoginUrl(String phone, String redirect, String timestamp, String sign);


    /**
     * 根据加密的客户UUID查询用户是否在白名单内
     *
     * @param partnerUserId 加密的客户UUID, 也即兑吧的partnerUserId
     * @return Y-在白名单, N-不在白名单, 接口请求异常返回{@code null}
     */
    String whitelistOrNot(String partnerUserId);

    /**
     * 查询奖品订单信息(查询领取状态)
     * @param prizeQueryParam 兑吧星速台recordId
     * @return 奖品领取信息
     */
    OrderQueryResult<Object> queryOrderInfo(PrizeQueryParam prizeQueryParam);

}
