package cn.com.duiba.customer.link.project.api.remoteservice.app84693;

import cn.com.duiba.customer.link.project.api.remoteservice.app84693.vo.ZsbQueryParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app84693.vo.ZsbQueryResult;
import cn.com.duiba.customer.link.project.api.remoteservice.app84693.vo.ZsbSendPrizeParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app84693.vo.ZsbSendPrizeResult;

public interface RemoteZheShangBank {

    /**
     * 根据手机号生成免登地址
     *
     * @param @param {"cstId": "客户id", "uniqueNo": "请求唯一id"}
     * @return 1-是白名单用户，0-非白名单用户
     */
    String inWhiteList(ZsbQueryParam param);

    /**
     * 活动达标发奖
     *
     * ⚠️⚠️：这个接口暂不支持幂等，目前确认的方案是落实走补发，同一个奖品不要调用多次
     *
     * @param param 发奖参数
     * @return
     */
    ZsbSendPrizeResult sendPrize(ZsbSendPrizeParam param);

    /**
     * 查询达标状态
     *
     * @param param {"cstId": "客户id", "uniqueNo": "请求唯一id"}
     * @return 0-未达标 1-已达标
     */
    String getCstActState(ZsbQueryParam param);

    /**
     * 查询立减金跳转链接
     */
    ZsbQueryResult getWxCouponUrl(ZsbQueryParam param);

}
