package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.dao;

import cn.com.duiba.customer.link.project.api.remoteservice.appisv1.constants.KeyFactory;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.utils.ExpireTime;

/**
 * @author KvDao
 * @Description
 * @date 2023/7/12 11:54
 */
public class IsvKvDao extends KeyFactory {

    /**
     * 设置标记
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean setTag(UserRequestApi api, String type, String userId, ExpireTime expireTime) {
        return api.getKeyValueApi().setIfAbsent(getTagKey(type, userId), 1L, expireTime);
    }

    /**
     * 删除标记
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean delTag(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().delete(getTagKey(type, userId));
    }

    /**
     * 获取标记
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static Long getTag(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().getLong(getTagKey(type, userId));
    }

    /**
     * 递增次数
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean incrTimes(UserRequestApi api, String type, String userId,long offset,Long limit, ExpireTime expireTime) {
        return api.getKeyValueApi().increase(getTimesKey(type, userId),offset,limit,expireTime);
    }

    /**
     * 获取次数
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static Long getTimes(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().getLong(getTimesKey(type, userId));
    }

    /**
     * 删除次数
     * @param api
     * @param type
     * @param userId
     * @return
     */
    public static boolean delTimes(UserRequestApi api, String type, String userId) {
        return api.getKeyValueApi().delete(getTimesKey(type, userId));
    }

}
