package cn.com.duiba.customer.link.project.api.remoteservice.app96149.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.dto.QueryCodeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.dto.SendRedDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.dto.ShenCeData;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.dto.WriteOffCodeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.BaseDuiBaResVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.NewUserInfoVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.OcrResopnseVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.QueryCodeVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.SendRedVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.WriteOffCodeVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.YiliCommonResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo.YingXiaoTianWangCommonResponse;
import cn.com.duiba.customer.link.project.common.annotation.SendPrize;

import java.util.List;

/**
 * @author lvgm
 * @date 2023/12/9
 */
public interface RemoteYiliQiaoleziService {

    /**
     * 获取百度与accessToken
     */
    String getBaiduAccessToken() throws BizException;

    /**
     * 百端云ocr识别接口
     */
    OcrResopnseVO ocr(String base64Img) throws BizException;

    /**
     * 获取伊利联蔚accessToken
     * @return
     * @throws BizException
     * https://docs.qq.com/doc/DTUVBeElOU2ZzZnVt
     */
    String getYiliLianWeiAccessToken() throws BizException;

    /**
     * 串码验证接口
     * https://docs.qq.com/doc/DTUVBeElOU2ZzZnVt
     */
    QueryCodeVO queryCode(QueryCodeDTO queryCodeDTO) throws BizException;

    /**
     * 串码核销接口
     * https://docs.qq.com/doc/DTUVBeElOU2ZzZnVt
     */
    WriteOffCodeVO writeOffCode(WriteOffCodeDTO writeOffCodeDTO) throws BizException;

    /**
     * 根据code获取小程序用户数据
     * https://msmarket.msx.digitalyili.com/#/document/index?path=1-1600317933023887361-1600318562210795521
     */
    YiliCommonResponse<NewUserInfoVO> getUserInfo(String code) throws Exception;

    /**
     * 获取营销天网Token
     */
    String getYingXiaoTianWangToken() throws BizException;


    @SendPrize(value = "tradeNo")
    YingXiaoTianWangCommonResponse<SendRedVO> sendRedPacket(SendRedDTO sendRedDTO) throws Exception;

    /**
     * 查询红包发放状态
     */
    YingXiaoTianWangCommonResponse<SendRedVO> queryRedPacketStatus(String tradeNo) throws Exception;

    /**
     * 刷新伊利token
     */
    YiliCommonResponse<NewUserInfoVO> refreshYiliToken(String refreshToken) throws Exception;

    /**
     * 发送神策数据
     * @param shenCeData 神策data
     * @return
     */
    BaseDuiBaResVO<Boolean> reportShenCeData(ShenCeData shenCeData);



}
