package cn.com.duiba.customer.link.project.api.remoteservice.app79331;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.security.*;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;

/**
 * @author zhangdaqing
 * @Description
 * @date 2023/4/16 21:03
 */
public class RemoteUtils {
    public static final String CHARSET = "UTF-8";
    public static final String RSA_ALGORITHM = "RSA";
    public static final String RSA_PEDDING = "SHA256withRSA";

    /**
     * bean转map
     *
     * @param bean 豆
     * @return {@link Map}<{@link String}, {@link String}>
     * @throws Exception 异常
     */
    public static Map<String, String> convertBeanToMap(Object bean) throws Exception {
        Class<?> clazz = bean.getClass();
        Map<String, String> map = new HashMap<>();
        PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            String name = propertyDescriptor.getName();
            if (!"class".equals(name)) {
                String value = propertyDescriptor.getReadMethod().invoke(bean).toString();
                map.put(name, value);
            }
        }
        return map;
    }

    public static <T> Map<String, String> entityToMap(T entity) throws IllegalAccessException {
        Map<String, String> map = new HashMap<>();
        Class<?> clazz = entity.getClass();
        while (clazz != null) {
            Field[] fields = clazz.getDeclaredFields();
            for (Field field : fields) {
                field.setAccessible(true);
                if (field.get(entity) != null) {
                    map.put(field.getName(), field.get(entity).toString());
                }
            }
            clazz = clazz.getSuperclass();
        }
        return map;
    }

    public static String getSignOriginData(Map<String, String> map) {
        StringBuilder sb = new StringBuilder();
        map.keySet().stream().sorted().forEach(key -> {
            String value = map.get(key);
            if (StringUtils.isEmpty(value)) {
                return;
            }
            sb.append("&").append(key).append("=").append(value);
        });
        return sb.substring(1);
    }

    /**
     * 得到私钥
     *
     * @param privateKey 密钥字符串（经过base64编码）
     * @throws Exception
     */
    public static RSAPrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        // 通过PKCS#8编码的Key指令获得私钥对象
        KeyFactory keyFactory = KeyFactory.getInstance(RSA_ALGORITHM);
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Base64.decodeBase64(privateKey));
        return (RSAPrivateKey) keyFactory.generatePrivate(pkcs8KeySpec);
    }


    /**
     * 私钥签名 sha256withRsa
     *
     * @param data
     * @param privateKey
     * @return sign
     * @throws Exception
     */

    public static String privateSign(String data, PrivateKey privateKey) {
        try {
            Signature signature = Signature.getInstance(RSA_PEDDING);
            signature.initSign(privateKey);
            signature.update(data.getBytes());
            return Base64.encodeBase64String(signature.sign());
        } catch (Exception e) {
            throw new RuntimeException("签名字符串[" + data + "]时遇到异常", e);
        }
    }

    public static String SHA256(String str) throws Exception {

        MessageDigest digest = java.security.MessageDigest
                .getInstance("SHA-256"); //
        digest.update(str.getBytes("UTF-8"));
        byte messageDigest[] = digest.digest();
        // Create Hex String
        StringBuffer hexStr = new StringBuffer();
        // 字节数组转换为 十六进制 数
        for (int i = 0; i < messageDigest.length; i++) {
            String shaHex = Integer.toHexString(messageDigest[i] & 0xFF);
            if (shaHex.length() < 2) {
                hexStr.append(0);
            }
            hexStr.append(shaHex);
        }
        return hexStr.toString();
    }

}
