package cn.com.duiba.customer.link.project.api.remoteservice.app85110;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app85110.request.ZsyhAddCreditsParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app85110.request.ZsyhDecreaseCreditsParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app85110.request.ZsyhParticipateGameParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app85110.response.ZsyhQueryResultRes;
import cn.com.duiba.customer.link.project.api.remoteservice.app85110.response.ZsyhRes;
import cn.com.duiba.customer.link.project.common.annotation.SendPrize;

public interface RemoteZsyhService {

    /**
     * 加积分
     */
    ZsyhRes addCredits(ZsyhAddCreditsParam param) throws BizException;


    /**
     *
     * 扣积分
     */
    @SendPrize(value = "serialNo")
    ZsyhRes decreaseCredits(ZsyhDecreaseCreditsParam param) throws BizException;

    /**
     * 参与游戏任务
     * @param param 请求参数
     * @return 响应参数
     * @throws BizException 业务异常
     */
    ZsyhRes participateGameTask(ZsyhParticipateGameParam param) throws BizException;

    /**
     * 游戏任务参与记录查询
     * @param param 请求参数
     * @return 响应参数
     * @throws BizException 业务异常
     */
    ZsyhQueryResultRes queryGameTaskRecord(ZsyhParticipateGameParam param) throws BizException;

    /**
     * 游戏风控校验
     */
    ZsyhRes checkGameUser(ZsyhCheckGameUserParam param);

}
