package cn.com.duiba.customer.link.project.api.remoteservice.app96136;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.dto.AddCreditRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.dto.QueryCodeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.dto.QueryCreditRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.dto.SubCreditRequestDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.dto.WriteOffCodeDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.vo.NewUserInfoVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.vo.QueryCodeVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.vo.QueryCreditResult;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.vo.WriteOffCodeVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app96136.vo.YiliCommonResponse;
import cn.com.duiba.customer.link.project.common.annotation.SendPrize;

public interface RemoteYiliXujinghuanService {

    /**
     * 获取伊利联蔚accessToken
     * @return
     * @throws BizException
     * https://docs.qq.com/doc/DTUVBeElOU2ZzZnVt
     */
    String getYiliLianWeiAccessToken() throws BizException;

    /**
     * 串码验证接口
     * https://docs.qq.com/doc/DTUVBeElOU2ZzZnVt
     */
    QueryCodeVO queryCode(QueryCodeDTO queryCodeDTO) throws BizException;

    /**
     * 串码核销接口
     * https://docs.qq.com/doc/DTUVBeElOU2ZzZnVt
     */
    WriteOffCodeVO writeOffCode(WriteOffCodeDTO writeOffCodeDTO) throws BizException;

    /**
     * 加积分接口
     *
     * @param addCreditRequestDto 加积分请求入参
     * @return 为true发放成功
     */
    @SendPrize("key")
    boolean addCredits(AddCreditRequestDto addCreditRequestDto);

    /**
     * 口积分接口
     *
     * @param subCreditRequestDto 扣积分请求入参
     * @return 为true扣减成功
     */
    @SendPrize("key")
    boolean subCredits(SubCreditRequestDto subCreditRequestDto);

    /**
     * 查询积分余额
     *
     * @param queryCreditRequestDto dto
     * @return 查询积分
     */
    QueryCreditResult queryCredit(QueryCreditRequestDto queryCreditRequestDto);

    /**
     * 根据code获取小程序用户数据
     * https://msmarket.msx.digitalyili.com/#/document/index?path=1-1600317933023887361-1600318562210795521
     */
    YiliCommonResponse<NewUserInfoVO> getUserInfo(String code) throws Exception;


}
