package cn.com.duiba.customer.link.project.api.remoteservice.app98604;

import cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.req.ConfirmTransferNotifyRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.req.ConfirmTransferRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.req.InitiateBatchTransferRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto.resp.*;

/**
 * 五羊雪糕
 */
public interface RemoteWyxgService {
    /**
     * 微信提现到零钱(旧接口，直接到账，有些商户可能不再支持调用)
     *
     * @param request
     * @return
     */
    InitiateBatchTransferResponse initiateBatchTransfer(InitiateBatchTransferRequest request);

    /**
     * 微信转账(新接口，需要用户点击确认收款，微信提现到零钱无法使用时使用此接口)
     * https://pay.weixin.qq.com/doc/v3/merchant/4012716434
     *
     * @param request
     * @return
     */
    ConfirmTransferResponse confirmTransfer(ConfirmTransferRequest request);

    /**
     * 微信转账查询(根据商户单号)
     * https://pay.weixin.qq.com/doc/v3/merchant/4012716437
     *
     * @param outBillNo 【商户单号】 商户系统内部的商家单号，要求此参数只能由数字、大小写字母组成，在商户系统内部唯一
     * @return
     */
    ConfirmTransferQueryResponse confirmTransferQuery(String outBillNo);

    /**
     * 微信转账通知回调
     * https://pay.weixin.qq.com/doc/v3/merchant/4012712115
     * 商户验签后，根据验签结果对回调进行应答：
     * 验签通过：商户需告知微信支付接收回调成功，HTTP应答状态码需返回200或204，无需返回应答报文。
     * 验签不通过：商户需告知微信支付接收回调失败，HTTP应答状态码需返回5XX或4XX，同时需返回以下应答报文：
     * Body 包体参数
     * 【返回状态码】错误码，SUCCESS为接收成功，其他错误码为失败
     * 应答示例
     * {
     * "code": "SUCCESS",
     * "message": "FAILED"
     * }
     * 对后台通知交互时，如果微信收到商户的应答不符合规范或超时，微信认为通知失败，微信会通过一定的策略定期重新发起通知，尽可能提高通知的成功率，但微信不保证通知最终能成功。（通知频率为0s/15s（尝试10次）/300s（尝试10次）/1800s（尝试44次)）
     *
     * @param request
     * @return
     */
    ConfirmTransferNotifyResponse confirmTransferNotify(ConfirmTransferNotifyRequest request);
}
