package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.dao;

import cn.com.duiba.projectx.sdk.querytable.QueryWrapper;
import cn.com.duiba.projectx.sdk.utils.PageList;
import cn.com.duiba.projectx.sdk.utils.QueryTableSp;
import org.apache.commons.collections.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * @author QtDao
 * @Description
 * @date 2023/7/12 13:41
 */
public class IsvQtDao {

    /**
     * 查询满足条件的所有数据
     * ⚠️wrapper至少传入一个排序条件
     * @param tableSp      query
     * @param queryWrapper wrapper
     * @param <T>          类型
     * @return 所有数据
     */
    public static <T> List<T> queryAll(QueryTableSp<T> tableSp, QueryWrapper<T> queryWrapper) {
        long page = 1;
        long pageSize = 2000;
        List<T> resultList = new ArrayList<>();
        PageList<T> pageList = tableSp.pageQuery(queryWrapper, page, pageSize);
        if (CollectionUtils.isEmpty(pageList.getList())) {
            return resultList;
        }

        resultList.addAll(pageList.getList());
        long totalPage = pageList.getTotalPage();
        if (totalPage == 1L) {
            return resultList;
        } else if (totalPage > 1L) {
            for (long i = 0; i < totalPage; i++) {
                page++;
                PageList<T> tempList = tableSp.pageQuery(queryWrapper, page, pageSize);
                if (CollectionUtils.isNotEmpty(tempList.getList())) {
                    resultList.addAll(tempList.getList());
                }
            }
        }

        return resultList;
    }

}
