package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.enums;

import cn.com.duiba.projectx.sdk.BizError;

public enum ErrorCode implements BizError {

    /**
     * 系统异常
     */
    SYSTEM_ERR(900000, "系统繁忙，请稍后再试"),

    /**
     * 系统异常
     */
    ACTIVITY_NOT_START(900001, "活动未开始"),

    /**
     * 活动已结束
     */
    ACTIVITY_END(900002, "活动已结束"),

    /**
     * 无次数
     */
    NO_TIMES(900003, "无次数"),

    /**
     * 重复领取
     */
    REPEAT_RECEIVE(900004, "重复领取"),

    /**
     * 配置异常
     */
    CONFIG_ERR(900005, "配置异常"),

    /**
     * 无资格
     */
    NO_QUALIFICATION(900006, "无资格"),

    /**
     * 库存不足
     */
    STOCK_NOT_ENOUGH(900007, "库存不足"),

    /**
     * 邀请者不存在
     */
    INVITER_NOT_EXIST(900008, "邀请者不存在"),

    ;

    ErrorCode(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    private final int errorCode;

    private final String errorMessage;

    @Override
    public int errorCode() {
        return errorCode;
    }

    @Override
    public String errorMessage() {
        return errorMessage;
    }
}
