package cn.com.duiba.customer.link.project.api.remoteservice.app96149.vo;

/**
 * @author LiJiang
 * @description 返回值基础类
 * @date 2022/12/6
 */
public class BaseDuiBaResVO<T> {
    /**
     * success为false必传
     */
    private String code;
    /**
     * 是否成功，true成功，否则失败
     */
    private Boolean success = false;
    /**
     * success为false必传
     */
    private String message;
    /**
     * 必要时有值
     */
    private T data;

    public static class Builder {

        public static <T> BaseDuiBaResVO<T> success(T data) {
            BaseDuiBaResVO<T> vo = new BaseDuiBaResVO<>();
            vo.setSuccess(true);
            vo.setData(data);
            return vo;
        }

        public static <T> BaseDuiBaResVO<T> fail(String code, String message, T data) {
            BaseDuiBaResVO<T> vo = new BaseDuiBaResVO<>();
            vo.setSuccess(false);
            vo.setCode(code);
            vo.setMessage(message);
            vo.setData(data);
            return vo;
        }

        public static <T> BaseDuiBaResVO<T> fail(ErrorCodeEnum errorCodeEnum, T data) {
            BaseDuiBaResVO<T> vo = new BaseDuiBaResVO<>();
            vo.setSuccess(false);
            vo.setCode(errorCodeEnum.getCode());
            vo.setMessage(errorCodeEnum.getMessage());
            vo.setData(data);
            return vo;
        }
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Boolean getSuccess() {
        return success;
    }

    public void setSuccess(Boolean success) {
        this.success = success;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

}
