package cn.com.duiba.customer.link.project.api.remoteservice.app92778;

import cn.com.duiba.customer.link.project.api.remoteservice.app92778.dto.DoExchangeResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.dto.QueryNewUserResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.dto.TaskResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.dto.UserLevelResultDto;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.param.DoExchangeParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.param.PushTaskParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.param.QueryNewUserParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.param.QueryTaskParam;

import cn.com.duiba.customer.link.project.api.remoteservice.app92778.param.UserLevelParam;
import cn.com.duiba.customer.link.project.api.remoteservice.app92778.vo.Result;

/**
 * 杭州银行-开门大吉
 *
 * @author songp
 * @date 2022/12/6 11:24 上午
 */
public interface RemoteHzyhService {

    /**
     * 查询任务完成情况
     *
     * @param taskParam 请求参数
     * @return 任务完成情况
     */
    Result<TaskResultDto> queryTask(QueryTaskParam taskParam);

    /**
     * 推送任务完成情况
     *
     * @param taskParam 请求参数
     * @return 推送结果
     */
    Result<Boolean> pushTaskResult(PushTaskParam taskParam);

    /**
     * 权益兑换
     * 第三方通过接口的形式发放客户权益，客户可通过我行手机银行->权益中心进行查询兑换成功的权益。
     *
     * @param doExchangeParam 请求参数
     * @return 兑换结果
     */
    Result<DoExchangeResultDto> doExchange(DoExchangeParam doExchangeParam);

    /**
     * 判断客户是否为新客接口
     *
     * @param queryNewUserParam 请求参数
     * @return 是否为新客
     */
    Result<QueryNewUserResultDto> queryNewUser(QueryNewUserParam queryNewUserParam);

    /**
     * 获取用户等级接口
     *
     * @param userLevelParam 请求参数
     * @return 等级下的用户
     */
    Result<UserLevelResultDto> pageQueryUserLevel(UserLevelParam userLevelParam);
}
