package cn.com.duiba.customer.link.project.api.remoteservice.app82621.dto;

/**
 * @Description 任务查询请求对象
 * @Author gjzhao
 * @Date Created in 2023-02-22 4:03 PM
 */
public class TaskInfoProjectxDTO {

    /** 活动标识符(uid) */
    private String authCode;

    /** 活动标识符: 例如: yrqysj001（悠然卡权益升级） */
    private String activityTag;

    /**
     * 具体需要查询的任务封装
     * 举例如下:
     * 1、新版本：
     * [
     *             {
     *                 "task": "equityRelationTask",
     *                 "info": [
     *                     {
     *                         "task": "openFirstAccountTask",
     *                         "infoList": [
     *                             {
     *                                 "cardType": "youran",
     *                                 "limitDate": ""
     *                             },
     *                             {
     *                                 "cardType": "youran",
     *                                 "limitDate": "6"
     *                             }
     *                         ]
     *                     }
     *                 ]
     *             }
     * ]
     *
     * 2、老版本：每次只能查询一个任务，比如6个月内开卡或者6个月外开卡
     * "taskInfoList": [
     *             {
     *                 "task": "openAccountTask",
     *                 "dateType": "open",
     *                 "monthNumber": "6",
     *                 "cardType": " youran",
     *                 "openType": "I"
     *             }
     *         ]
     */
    String info;


    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getActivityTag() {
        return activityTag;
    }

    public void setActivityTag(String activityTag) {
        this.activityTag = activityTag;
    }

    public String getInfo() {
        return info;
    }

    public void setInfo(String info) {
        this.info = info;
    }
}
