package cn.com.duiba.customer.link.project.api.remoteservice.app89569.dto;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

/**
 * 查询风控请求参数
 *
 * @author songp
 * @date 2024/4/28 10:12 上午
 */
public class RiskResultReq {


    /**
     * 用户账号类型；默认开通QQOpenId、手机号MD5权限；如果需要使用微信OpenId入参，则需要"提交工单"或联系对接人进行资格审核，审核通过后方可正常使用微信开放账号。
     1：QQ开放账号
     2：微信开放账号
     8：设备号，仅支持IMEI、IMEIMD5、IDFA、IDFAMD5
     10004：手机号MD5，中国大陆11位手机号进行MD5加密，取32位小写值。
     */
    @SerializedName("Account")
    @Expose
    private AccountInfo Account;

    /**
     * 场景码，用于识别和区分不同的业务场景，可在控制台上新建和管理
     控制台链接：https://console.cloud.tencent.com/rce/risk/strategy/scene-root
     活动防刷默认场景码：e_activity_antirush
     登录保护默认场景码：e_login_protection
     注册保护默认场景码：e_register_protection
     */
    @SerializedName("SceneCode")
    @Expose
    private String SceneCode;

    /**
     * 用户外网ip（传入用户非外网ip会影响判断结果）。
     */
    @SerializedName("UserIp")
    @Expose
    private String UserIp;

    /**
     * 用户操作时间戳，精确到秒。
     */
    @SerializedName("PostTime")
    @Expose
    private Long PostTime;

    /**
     * 业务平台用户唯一标识，支持自定义。
     */
    @SerializedName("UserId")
    @Expose
    private String UserId;

    /**
     * 设备指纹DeviceToken值，集成设备指纹后获取；如果集成了相应的设备指纹，该字段必填。
     */
    @SerializedName("DeviceToken")
    @Expose
    private String DeviceToken;

    /**
     * 设备指纹 BusinessId。
     */
    @SerializedName("DeviceBusinessId")
    @Expose
    private Long DeviceBusinessId;

    /**
     * 业务ID。网站或应用在多个业务中使用此服务，通过此ID区分统计数据。
     */
    @SerializedName("BusinessId")
    @Expose
    private Long BusinessId;

    /**
     * 昵称，UTF-8 编码。
     */
    @SerializedName("Nickname")
    @Expose
    private String Nickname;

    /**
     * 用户邮箱地址。
     */
    @SerializedName("EmailAddress")
    @Expose
    private String EmailAddress;

    /**
     * 是否识别设备异常：
     0：不识别。
     1：识别。
     */
    @SerializedName("CheckDevice")
    @Expose
    private Long CheckDevice;

    /**
     * 用户HTTP请求中的Cookie进行2次hash的值，只要保证相同Cookie的hash值一致即可。
     */
    @SerializedName("CookieHash")
    @Expose
    private String CookieHash;

    /**
     * 用户HTTP请求的Referer值。
     */
    @SerializedName("Referer")
    @Expose
    private String Referer;

    /**
     * 用户HTTP请求的User-Agent值。
     */
    @SerializedName("UserAgent")
    @Expose
    private String UserAgent;

    /**
     * 用户HTTP请求的X-Forwarded-For值。
     */
    @SerializedName("XForwardedFor")
    @Expose
    private String XForwardedFor;

    /**
     * MAC地址或设备唯一标识。
     */
    @SerializedName("MacAddress")
    @Expose
    private String MacAddress;

    /**
     * 手机制造商ID，如果手机注册，请带上此信息。
     */
    @SerializedName("VendorId")
    @Expose
    private String VendorId;

    /**
     * 设备类型，账号类型（AccountType）为8时填写。
     1:IMEI；国际移动设备识别号（15-17位数字）；
     2:IMEIMD5；国际移动设备识别号，通过MD5加密后取32位小写值；
     3:IDFA；
     4:IDFAMD5；国际移动设备识别号，通过MD5加密后取32位小写值。
     */
    @SerializedName("DeviceType")
    @Expose
    private Long DeviceType;

    /**
     * 扩展字段。
     */
    @SerializedName("Details")
    @Expose
    private InputDetails[] Details;

    /**
     * 邀请助力场景相关信息。
     */
    @SerializedName("Sponsor")
    @Expose
    private SponsorInfo Sponsor;

    /**
     * 详情请跳转至OnlineScamInfo查看。
     */
    @SerializedName("OnlineScam")
    @Expose
    private OnlineScamInfo OnlineScam;

    /**
     * 1：Android
     2：iOS
     3：H5
     4：小程序

     */
    @SerializedName("Platform")
    @Expose
    private String Platform;

    public AccountInfo getAccount() {
        return Account;
    }

    public void setAccount(AccountInfo account) {
        Account = account;
    }

    public String getSceneCode() {
        return SceneCode;
    }

    public void setSceneCode(String sceneCode) {
        SceneCode = sceneCode;
    }

    public String getUserIp() {
        return UserIp;
    }

    public void setUserIp(String userIp) {
        UserIp = userIp;
    }

    public Long getPostTime() {
        return PostTime;
    }

    public void setPostTime(Long postTime) {
        PostTime = postTime;
    }

    public String getUserId() {
        return UserId;
    }

    public void setUserId(String userId) {
        UserId = userId;
    }

    public String getDeviceToken() {
        return DeviceToken;
    }

    public void setDeviceToken(String deviceToken) {
        DeviceToken = deviceToken;
    }

    public Long getDeviceBusinessId() {
        return DeviceBusinessId;
    }

    public void setDeviceBusinessId(Long deviceBusinessId) {
        DeviceBusinessId = deviceBusinessId;
    }

    public Long getBusinessId() {
        return BusinessId;
    }

    public void setBusinessId(Long businessId) {
        BusinessId = businessId;
    }

    public String getNickname() {
        return Nickname;
    }

    public void setNickname(String nickname) {
        Nickname = nickname;
    }

    public String getEmailAddress() {
        return EmailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        EmailAddress = emailAddress;
    }

    public Long getCheckDevice() {
        return CheckDevice;
    }

    public void setCheckDevice(Long checkDevice) {
        CheckDevice = checkDevice;
    }

    public String getCookieHash() {
        return CookieHash;
    }

    public void setCookieHash(String cookieHash) {
        CookieHash = cookieHash;
    }

    public String getReferer() {
        return Referer;
    }

    public void setReferer(String referer) {
        Referer = referer;
    }

    public String getUserAgent() {
        return UserAgent;
    }

    public void setUserAgent(String userAgent) {
        UserAgent = userAgent;
    }

    public String getXForwardedFor() {
        return XForwardedFor;
    }

    public void setXForwardedFor(String XForwardedFor) {
        this.XForwardedFor = XForwardedFor;
    }

    public String getMacAddress() {
        return MacAddress;
    }

    public void setMacAddress(String macAddress) {
        MacAddress = macAddress;
    }

    public String getVendorId() {
        return VendorId;
    }

    public void setVendorId(String vendorId) {
        VendorId = vendorId;
    }

    public Long getDeviceType() {
        return DeviceType;
    }

    public void setDeviceType(Long deviceType) {
        DeviceType = deviceType;
    }

    public InputDetails[] getDetails() {
        return Details;
    }

    public void setDetails(InputDetails[] details) {
        Details = details;
    }

    public SponsorInfo getSponsor() {
        return Sponsor;
    }

    public void setSponsor(SponsorInfo sponsor) {
        Sponsor = sponsor;
    }

    public OnlineScamInfo getOnlineScam() {
        return OnlineScam;
    }

    public void setOnlineScam(OnlineScamInfo onlineScam) {
        OnlineScam = onlineScam;
    }

    public String getPlatform() {
        return Platform;
    }

    public void setPlatform(String platform) {
        Platform = platform;
    }
}
