package cn.com.duiba.customer.link.project.api.remoteservice.app92580.dto;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;

import java.util.Date;

/**
 * write_your_class_description_here
 *
 * @author xulei
 * @since 1.0.0
 */
public class ReportWinPrizeInfoDTO {

    /**
     * 请求唯一标识 <br>
     * 必须
     */
    private String distinctId;

    /**
     * loginId, 使用默认值即可 <br>
     * 必须
     */
    private Boolean loginId = true;

    /**
     * eventName, 使用默认值即可 <br>
     * 必须
     */
    private String eventName = "$pageview";

    /**
     * 事件发生时间 <br>
     * 必须
     */
    private Date time;

    /**
     * sit为: sit_wxsc UAT为: uat, 生产为: default <br>
     * 必须
     */
    private String project;

    /**
     * token, 使用默认值即可 <br>
     * 必须
     */
    private String token = "123";

    /**
     * 活动名称首拼缩写 <br>
     * 必须
     */
    private String titleId;

    /**
     * 代理人中宏用户id(mslId) <br>
     * 必须
     */
    private String firstShareDistinctId;

    /**
     * 上一个分享人中宏用户id(mslId) <br>
     * 必须
     */
    private String shareDistinctId;

    /**
     * 用户当前所属分享层级, 代理人本人为0，后续1, 2, 3... <br>
     * 必须
     */
    private Integer shareDepth;

    /**
     * 主活动标题 <br>
     * 必须
     */
    private String title;

    /**
     * 用户unionId <br>
     * 必须
     */
    private String unionId;

    /**
     * 用户openId <br>
     * 必须
     */
    private String openId;

    /**
     * 直播/活动 <br>
     * 必须
     */
    private String pageType = "活动";

    /**
     * 子页面标题 <br>
     * 必须
     */
    private String titleName;

    /**
     * 头像 <br>
     * 必须
     */
    private String headPic;

    /**
     * 昵称 <br>
     * 必须
     */
    private String nickname;

    /**
     * 小程序: mp, 独立H5: H5 <br>
     * 必须
     */
    private String portType = "H5";

    /**
     * {"article_type":"KJJ","activity_url":"pages/webview/game/index?url=encode后活动奖品页地址"} <br>
     * 必须
     */
    @JSONField(name = "activity_params")
    private JSONObject activityParams;

    /**
     * 中奖信息 <br>
     * 必须
     */
    private WinPrizeInfo winPrizeInfo;

    /**
     * 有效销售线索标识, 使用默认值即可 <br>
     * 必须
     */
    private Integer flag = 1;

    public String getDistinctId() {
        return distinctId;
    }

    public void setDistinctId(String distinctId) {
        this.distinctId = distinctId;
    }

    public Boolean getLoginId() {
        return loginId;
    }

    public void setLoginId(Boolean loginId) {
        this.loginId = loginId;
    }

    public String getEventName() {
        return eventName;
    }

    public void setEventName(String eventName) {
        this.eventName = eventName;
    }

    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public String getProject() {
        return project;
    }

    public void setProject(String project) {
        this.project = project;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public String getTitleId() {
        return titleId;
    }

    public void setTitleId(String titleId) {
        this.titleId = titleId;
    }

    public String getFirstShareDistinctId() {
        return firstShareDistinctId;
    }

    public void setFirstShareDistinctId(String firstShareDistinctId) {
        this.firstShareDistinctId = firstShareDistinctId;
    }

    public String getShareDistinctId() {
        return shareDistinctId;
    }

    public void setShareDistinctId(String shareDistinctId) {
        this.shareDistinctId = shareDistinctId;
    }

    public Integer getShareDepth() {
        return shareDepth;
    }

    public void setShareDepth(Integer shareDepth) {
        this.shareDepth = shareDepth;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getPageType() {
        return pageType;
    }

    public void setPageType(String pageType) {
        this.pageType = pageType;
    }

    public String getTitleName() {
        return titleName;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }

    public String getHeadPic() {
        return headPic;
    }

    public void setHeadPic(String headPic) {
        this.headPic = headPic;
    }

    public String getNickname() {
        return nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getPortType() {
        return portType;
    }

    public void setPortType(String portType) {
        this.portType = portType;
    }

    public JSONObject getActivityParams() {
        return activityParams;
    }

    public void setActivityParams(JSONObject activityParams) {
        this.activityParams = activityParams;
    }

    public WinPrizeInfo getWinPrizeInfo() {
        return winPrizeInfo;
    }

    public void setWinPrizeInfo(WinPrizeInfo winPrizeInfo) {
        this.winPrizeInfo = winPrizeInfo;
    }

    public Integer getFlag() {
        return flag;
    }

    public void setFlag(Integer flag) {
        this.flag = flag;
    }

    public static class WinPrizeInfo {

        /**
         * 奖品id
         */
        private String prizeId;

        /**
         * 奖品名称
         */
        private String prizeName;

        /**
         * 奖品图片
         */
        private String prizeImg;

        /**
         * 奖品来源: 传入活动的总名称 <br>
         * 必须
         */
        private String prizeFrom;

        /**
         * 获奖时间, 如: 2022-05-01 17:01:00 <br>
         */
        private String prizeDate;

        /**
         * 奖品生效时间, 如: 2022-05-01 17:01:00 <br>
         * 必须
         */
        private String validDate;

        /**
         * 奖品失效时间, 如: 2022-05-01 17:01:00 <br>
         * 必须
         */
        private String inValidDate;

        /**
         * 大平台名称, 一般为厂商拼音或英文 <br>
         * 必须
         */
        @JSONField(name = "article_type")
        private String articleType;

        /**
         * 埋点系统为H5时使用, 小程序线索跳转url, 格式为pages/webview/KjjWebview/index?url=encode之后的url地址, 前面地址由albert提供 <br>
         * 必须
         */
        @JSONField(name = "activity_url")
        private String activityUrl;

        /**
         * 埋点系统为小程序时使用, 为微信appid
         */
        @JSONField(name = "mp_appid")
        private String mpAppid;

        /**
         * 埋点系统为小程序时使用, 为小程序地址, 如/packages/channel/pages/manulife/pre-enter/index?liveId=XX
         */
        @JSONField(name = "mp_url")
        private String mpUrl;

        /**
         * 默认值是init, 使用时上报状态为used
         */
        @JSONField(name = "price_status")
        private String priceStatus;

        /**
         * 每一条奖品记录的唯一流水号, 用来更新奖品状态
         */
        @JSONField(name = "price_uuid")
        private String priceUuid;

        public String getPrizeId() {
            return prizeId;
        }

        public void setPrizeId(String prizeId) {
            this.prizeId = prizeId;
        }

        public String getPrizeName() {
            return prizeName;
        }

        public void setPrizeName(String prizeName) {
            this.prizeName = prizeName;
        }

        public String getPrizeImg() {
            return prizeImg;
        }

        public void setPrizeImg(String prizeImg) {
            this.prizeImg = prizeImg;
        }

        public String getPrizeFrom() {
            return prizeFrom;
        }

        public void setPrizeFrom(String prizeFrom) {
            this.prizeFrom = prizeFrom;
        }

        public String getPrizeDate() {
            return prizeDate;
        }

        public void setPrizeDate(String prizeDate) {
            this.prizeDate = prizeDate;
        }

        public String getValidDate() {
            return validDate;
        }

        public void setValidDate(String validDate) {
            this.validDate = validDate;
        }

        public String getInValidDate() {
            return inValidDate;
        }

        public void setInValidDate(String inValidDate) {
            this.inValidDate = inValidDate;
        }

        public String getArticleType() {
            return articleType;
        }

        public void setArticleType(String articleType) {
            this.articleType = articleType;
        }

        public String getActivityUrl() {
            return activityUrl;
        }

        public void setActivityUrl(String activityUrl) {
            this.activityUrl = activityUrl;
        }

        public String getMpAppid() {
            return mpAppid;
        }

        public void setMpAppid(String mpAppid) {
            this.mpAppid = mpAppid;
        }

        public String getMpUrl() {
            return mpUrl;
        }

        public void setMpUrl(String mpUrl) {
            this.mpUrl = mpUrl;
        }

        public String getPriceStatus() {
            return priceStatus;
        }

        public void setPriceStatus(String priceStatus) {
            this.priceStatus = priceStatus;
        }

        public String getPriceUuid() {
            return priceUuid;
        }

        public void setPriceUuid(String priceUuid) {
            this.priceUuid = priceUuid;
        }
    }
}
