
package cn.com.duiba.customer.link.project.api.remoteservice.app98604.dto;

/**
 * TransferDetailInput
 */
public class TransferDetailInput {
    /**
     * 商家明细单号 说明：商户系统内部区分转账批次单下不同转账明细单的唯一标识，要求此参数只能由数字、大小写字母组成
     */
    private String out_detail_no;

    /**
     * 转账金额 说明：转账金额单位为“分”
     */
    private Long transfer_amount;

    /**
     * 转账备注 说明：单条转账备注（微信用户会收到该备注），UTF8编码，最多允许32个字符
     */
    private String transfer_remark;

    /**
     * 收款用户openid 说明：商户appid下，某用户的openid
     */
    private String openid;

    /**
     * 收款用户姓名 说明：收款方真实姓名。支持标准RSA算法和国密算法，公钥由微信侧提供 明细转账金额<0.3元时，不允许填写收款用户姓名 明细转账金额 >=
     * 2,000元时，该笔明细必须填写收款用户姓名 同一批次转账明细中的姓名字段传入规则需保持一致，也即全部填写、或全部不填写
     * 若商户传入收款用户姓名，微信支付会校验用户openID与姓名是否一致，并提供电子回单
     */
//  @Encryption
    private String user_name;


    public String getOut_detail_no() {
        return out_detail_no;
    }

    public void setOut_detail_no(String out_detail_no) {
        this.out_detail_no = out_detail_no;
    }

    public Long getTransfer_amount() {
        return transfer_amount;
    }

    public void setTransfer_amount(Long transfer_amount) {
        this.transfer_amount = transfer_amount;
    }

    public String getTransfer_remark() {
        return transfer_remark;
    }

    public void setTransfer_remark(String transfer_remark) {
        this.transfer_remark = transfer_remark;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getUser_name() {
        return user_name;
    }

    public void setUser_name(String user_name) {
        this.user_name = user_name;
    }
}
