package cn.com.duiba.customer.link.project.api.remoteservice.app84693.vo;

/**
 * 通用查询接口参数
 */
public class ZsbQueryParam {
    /**
     * 活动Id(此参数不传则取默认环境对应的配置)
     * <p>
     * taskType 送1001以及1002时该字段送积分值
     */
    private String actId;
    /**
     * 客户id
     */
    private String cstId;
    /**
     * 请求唯一id
     */
    private String uniqueId;

    /**
     * 客户接口环境，可选test,pre,prod
     * 可使用SpringEnvironmentUtils常量
     */
    private String env;

    /**
     * 立减金id，仅仅查询立减金跳转链接接口需要此参数
     */
    private String eshopCstWxCpnId;

    /**
     * 仅查询达标状态接口需要此参数
     * 1：养老金开户
     * 2：手机银行打开推送消息
     * 3：借记卡微信绑卡
     * 4：资产活动差额5万以上
     * 5：资产活动差额1万以上
     * 6：资产活动差额1千以上
     * 11：活动期间支付笔数
     * 12：活动期间支付金额大于1元笔数
     * 13：活动期间支付总额
     * 17：查询任务中心活动期间所有任务完成情况（暂定）
     *
     * 如果查询类型是17 则返回以下下任务的所有集合的json字符串
     * 1401：活动期间完成话费充值
     * 1402：活动期间完成理财购买
     * 1403：活动期间完成基金购买
     * 1404：活动期间完成存款产品购买
     * 1405：活动期间完成首次开通通知权限
     * 1406：活动期间完成首次开通生物识别
     * 1407：活动期间完成首次开通快捷支付
     * 1408：活动期间签到
     * 1409:活动期间参加特定活动
     */
    private String taskType;

    /**
     * 是否使用脱敏客户号 1-使用脱敏客户号
     */
    private String randomCustomerIdFlag;

    public String getRandomCustomerIdFlag() {
        return randomCustomerIdFlag;
    }

    public void setRandomCustomerIdFlag(String randomCustomerIdFlag) {
        this.randomCustomerIdFlag = randomCustomerIdFlag;
    }

    public String getCstId() {
        return cstId;
    }

    public void setCstId(String cstId) {
        this.cstId = cstId;
    }

    public String getUniqueId() {
        return uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
    }

    public String getEshopCstWxCpnId() {
        return eshopCstWxCpnId;
    }

    public void setEshopCstWxCpnId(String eshopCstWxCpnId) {
        this.eshopCstWxCpnId = eshopCstWxCpnId;
    }

    public String getEnv() {
        return env;
    }

    public void setEnv(String env) {
        this.env = env;
    }

    public String getTaskType() {
        return taskType;
    }

    public void setTaskType(String taskType) {
        this.taskType = taskType;
    }

    public String getActId() {
        return actId;
    }

    public void setActId(String actId) {
        this.actId = actId;
    }
}
