package cn.com.duiba.customer.link.project.api.remoteservice.app95721.dto.res;

/**
 * 有赞B端发券返回
 */
public class YzCouponSendForBRes {
    /**
     * 返回状态
     * 200:处理成功
     * 500:处理失败
     * 202:处理中
     */
    private Integer resultStatus;
    /**
     * 结果编码
     * F999999:——————系统异常
     * F999998:ILLEGAL_PARAMS
     * F999997:SYSTEM_TIMEOUT
     * F999996:SYSTEM_ERROR_NEED_RETRY
     * F990001:——————-DB异常
     * F990002:UPDATE
     * F990003:DELETE
     * F990004:SELECT
     * F990005:DB_ERROR
     */
    private String resultCode;
    /**
     * 结构信息
     */
    private String resultMessage;
    /**
     * 返回成功具体信息
     */
    private RespData data;

    public Integer getResultStatus() {
        return resultStatus;
    }

    public void setResultStatus(Integer resultStatus) {
        this.resultStatus = resultStatus;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getResultMessage() {
        return resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public RespData getData() {
        return data;
    }

    public void setData(RespData data) {
        this.data = data;
    }

    public static class RespData {
        /**
         * 有赞侧优惠券活动ID
         */
        private String activityId;
        /**
         * 用户手机列表
         */
        private String mobile;
        /**
         * 用户手机列表
         */
        private String yzOpenId;
        /**
         * 买家优惠券/码id，即买家在店铺个人中心看到的优惠码对应的id
         */
        private String couponId;
        /**
         * 凭证类型，0：优惠券，1：优惠码
         */
        private Integer couponType;
        /**
         * 面额，单位：分
         */
        private Integer value;
        /**
         * 领取消息文案优惠券存在，优惠码不存在为null
         */
        private String takenMessage;
        /**
         * 店铺kdtId
         */
        private String kdtId;
        /**
         * 码值
         */
        private String codeValue;
        /**
         * 指定核销码(核销码不能以ZAN,YZAN为前缀)，核销码长度：6-20个字符
         */
        private String verifyCode;
        /**
         * 核销的订单号
         */
        private String verifyInOrder;
        /**
         * 有效结束时间,时间格式：yyyy-MM-DDHH-MM-SS
         */
        private String validEndTime;
        /**
         * 凭证状态，
         * 1：正常
         * 2：已冻结（是核销的一个中间状态，核销的场景下，会先冻结后核销），
         * 3：已核销，
         * 4：不可用（商家端：点击优惠券列表中的以领取数量，进入领取列表，右侧有作废
         * 按钮，操作后优惠券为不可用），5：
         * 已删除（比如支付有礼送券，如果支付有礼的订单退款了，送出去的券会变成删
         * 除）；
         */
        private Integer status;
        /**
         * 发券店铺id
         */
        private String sendKdtId;
        /**
         * 发放时间，时间格式：yyyy-MM-DDHH-MM-SS
         */
        private String sentAt;
        /**
         * 核销店铺
         */
        private Integer verifiedKdtId;
        /**
         * 优惠方式，1：代金券，2：折扣券，3：兑换券
         */
        private Integer preferentialMode;
        /**
         * 有效开始时间,时间格式：yyyy-MM-DDHH-MM-SS
         */
        private String validStartTime;

        public String getActivityId() {
            return activityId;
        }

        public void setActivityId(String activityId) {
            this.activityId = activityId;
        }

        public String getMobile() {
            return mobile;
        }

        public void setMobile(String mobile) {
            this.mobile = mobile;
        }

        public String getYzOpenId() {
            return yzOpenId;
        }

        public void setYzOpenId(String yzOpenId) {
            this.yzOpenId = yzOpenId;
        }

        public String getCouponId() {
            return couponId;
        }

        public void setCouponId(String couponId) {
            this.couponId = couponId;
        }

        public Integer getCouponType() {
            return couponType;
        }

        public void setCouponType(Integer couponType) {
            this.couponType = couponType;
        }

        public Integer getValue() {
            return value;
        }

        public void setValue(Integer value) {
            this.value = value;
        }

        public String getTakenMessage() {
            return takenMessage;
        }

        public void setTakenMessage(String takenMessage) {
            this.takenMessage = takenMessage;
        }

        public String getKdtId() {
            return kdtId;
        }

        public void setKdtId(String kdtId) {
            this.kdtId = kdtId;
        }

        public String getCodeValue() {
            return codeValue;
        }

        public void setCodeValue(String codeValue) {
            this.codeValue = codeValue;
        }

        public String getVerifyCode() {
            return verifyCode;
        }

        public void setVerifyCode(String verifyCode) {
            this.verifyCode = verifyCode;
        }

        public String getVerifyInOrder() {
            return verifyInOrder;
        }

        public void setVerifyInOrder(String verifyInOrder) {
            this.verifyInOrder = verifyInOrder;
        }

        public String getValidEndTime() {
            return validEndTime;
        }

        public void setValidEndTime(String validEndTime) {
            this.validEndTime = validEndTime;
        }

        public Integer getStatus() {
            return status;
        }

        public void setStatus(Integer status) {
            this.status = status;
        }

        public String getSendKdtId() {
            return sendKdtId;
        }

        public void setSendKdtId(String sendKdtId) {
            this.sendKdtId = sendKdtId;
        }

        public String getSentAt() {
            return sentAt;
        }

        public void setSentAt(String sentAt) {
            this.sentAt = sentAt;
        }

        public Integer getVerifiedKdtId() {
            return verifiedKdtId;
        }

        public void setVerifiedKdtId(Integer verifiedKdtId) {
            this.verifiedKdtId = verifiedKdtId;
        }

        public Integer getPreferentialMode() {
            return preferentialMode;
        }

        public void setPreferentialMode(Integer preferentialMode) {
            this.preferentialMode = preferentialMode;
        }

        public String getValidStartTime() {
            return validStartTime;
        }

        public void setValidStartTime(String validStartTime) {
            this.validStartTime = validStartTime;
        }
    }
}
