package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * QQ小程序大单购活动订单信息
 * 
 * @author zhangdaqing
 * @date 2025/1/20
 */
public class QQBigBuyOrderInfo {
    
    @JSONField(name = "OrderID")
    private final String orderId;
    
    @JSONField(name = "GiftCode")
    private final String giftCode;
    
    @JSONField(name = "AcceptDate")
    private final String acceptDate;
    
    /**
     * 构造函数
     * @param orderId 大单购活动订单ID
     * @param giftCode 兑换礼品编码
     * @param acceptDate 参与时间
     */
    public QQBigBuyOrderInfo(String orderId, String giftCode, String acceptDate) {
        this.orderId = orderId;
        this.giftCode = giftCode;
        this.acceptDate = acceptDate;
    }
    
    /**
     * 获取大单购活动订单ID
     * @return 订单ID
     */
    public String getOrderId() {
        return orderId;
    }
    
    /**
     * 获取兑换礼品编码
     * @return 礼品编码
     */
    public String getGiftCode() {
        return giftCode;
    }
    
    /**
     * 获取参与时间
     * @return 参与时间
     */
    public String getAcceptDate() {
        return acceptDate;
    }
    
    @Override
    public String toString() {
        return "QQBigBuyOrderInfo{" +
                "orderId='" + orderId + '\'' +
                ", giftCode='" + giftCode + '\'' +
                ", acceptDate='" + acceptDate + '\'' +
                '}';
    }
}
