package cn.com.duiba.customer.link.project.api.remoteservice.app70398;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.request.ActQueryRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.request.MiniproUrlCreateRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.dto.ResultListDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.request.RightSendRequest;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.vo.ActQueryResultVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.vo.MiniproUrlResultVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.vo.RightSendResultVO;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.dto.SendDTO;
import cn.com.duiba.customer.link.project.api.remoteservice.app70398.vo.CiticBankResult;

/**
 * @author LiJiang
 * @description
 * @date 2022/11/21
 */
public interface CiticBankRemoteService {
    /**
     * 发奖接口
     *
     * @return
     */
    CiticBankResult<ResultListDTO> send(SendDTO sendDto) throws BizException;

    /**
     * 权益发放接口(IFWPE007)
     *
     * @param request
     * @return
     * @throws BizException
     */
    RightSendResultVO rightSend(RightSendRequest request) throws BizException;

    /**
     * 预设领取信息(IFQYE003)+小程序跳转链接生成(IFQYE005)
     *
     * @param request
     * @return
     * @throws BizException
     */
    MiniproUrlResultVO getMiniproUrl(MiniproUrlCreateRequest request) throws BizException;

    /**
     * 活动中心活动指标详情查询(IFQYE004)
     *
     * @param request
     * @return
     * @throws BizException
     */
    ActQueryResultVO actQuery(ActQueryRequest request) throws BizException;

}
