package cn.com.duiba.customer.link.project.api.remoteservice.app89569.vo;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

import java.io.Serializable;

/**
 * 查询风控结果
 *
 * @author songp
 * @date 2024/4/28 10:08 上午
 */
public class RiskResultRes implements Serializable {

    /**
     * 账号ID：对应输入参数。
     * 当AccountType为1时，对应QQ的OpenId。
     * 当AccountType为2时，对应微信的OpenId/UnionId。
     * 当AccountType为8时，对应IMEI、IDFA、IMEIMD5或者IDFAMD5。
     * 当AccountType为10004时，对应手机号的MD5值。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("UserId")
    @Expose
    private String UserId;

    /**
     * 操作时间戳，单位秒（对应输入参数）。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("PostTime")
    @Expose
    private Long PostTime;

    /**
     * 业务参数。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("AssociateAccount")
    @Expose
    private String AssociateAccount;

    /**
     * 操作来源的外网IP（对应输入参数）。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("UserIp")
    @Expose
    private String UserIp;

    /**
     * 风险等级
     * pass：无恶意
     * review：低风险，需要人工审核
     * reject：高风险，建议拦截
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("RiskLevel")
    @Expose
    private String RiskLevel;

    /**
     * 风险类型，可能同时命中多个风险类型
     * 1: 账号信用低，账号近期存在因恶意被处罚历史，网络低活跃，被举报等因素。
     * 11: 疑似低活跃账号，账号活跃度与正常用户有差异。
     * 2: 垃圾账号，疑似批量注册小号，近期存在严重违规或大量举报。
     * 21: 疑似小号，账号有疑似线上养号，小号等行为。
     * 22: 疑似违规账号，账号曾有违规行为、曾被举报过、曾因违规被处罚过等。
     * 3: 无效账号，送检账号参数无法成功解析，请检查微信 OpenId 是否有误/AppId 与 QQ OpenId 无法关联/微信 OpenId 权限是否开通/手机号是否为中国大陆手机号；
     * 4: 黑名单，该账号在业务侧有过拉黑记录。
     * 5: 白名单，业务自行有添加过白名单记录。
     * 101: 批量操作，存在 IP/设备/环境等因素的聚集性异常。
     * 1011: 疑似 IP 属性聚集，出现 IP 聚集。
     * 1012: 疑似设备属性聚集，出现设备聚集。
     * 102: 自动机，疑似自动机批量请求。
     * 103: 恶意行为-网赚，疑似网赚。
     * 104: 微信登录态无效，检查 WeChatAccessToken 参数，是否已经失效。
     * 201: 环境风险，环境异常操作 IP/设备/环境存在异常。当前 IP 为非常用 IP 或恶意 IP 段。
     * 2011: 疑似非常用IP，请求当前请求 IP 非该账号常用 IP。
     * 2012: 疑似 IP 异常，使用 IDC 机房 IP 或使用代理 IP 或使用恶意 IP 等。
     * 205: 非公网有效 IP，传进来的 IP 地址为内网 IP 地址或者 IP 保留地址。
     * 206: 设备异常，该设备存在异常的使用行为。
     * 2061: 疑似非常用设备，当前请求的设备非该账号常用设备。
     * 2062: 疑似虚拟设备，请求设备为模拟器、脚本、云设备等虚拟设备。
     * 2063: 疑似群控设备，请求设备为猫池、手机墙等群控设备。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("RiskType")
    @Expose
    private Long[] RiskType;

    /**
     * 设备指纹ID，如果集成了设备指纹，并传入了正确的DeviceToken和Platform，该字段正常输出；如果DeviceToken异常（校验不通过），则会在RiskType中返回"-1"标签，ConstId字段为空；如果没有集成设备指纹ConstId字段默认为空。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("ConstId")
    @Expose
    private String ConstId;

    /**
     * 风险扩展数据。
     * 注意：此字段可能返回 null，表示取不到有效值。
     */
    @SerializedName("RiskInformation")
    @Expose
    private String RiskInformation;

    public String getUserId() {
        return UserId;
    }

    public void setUserId(String userId) {
        UserId = userId;
    }

    public Long getPostTime() {
        return PostTime;
    }

    public void setPostTime(Long postTime) {
        PostTime = postTime;
    }

    public String getAssociateAccount() {
        return AssociateAccount;
    }

    public void setAssociateAccount(String associateAccount) {
        AssociateAccount = associateAccount;
    }

    public String getUserIp() {
        return UserIp;
    }

    public void setUserIp(String userIp) {
        UserIp = userIp;
    }

    public String getRiskLevel() {
        return RiskLevel;
    }

    public void setRiskLevel(String riskLevel) {
        RiskLevel = riskLevel;
    }

    public Long[] getRiskType() {
        return RiskType;
    }

    public void setRiskType(Long[] riskType) {
        RiskType = riskType;
    }

    public String getConstId() {
        return ConstId;
    }

    public void setConstId(String constId) {
        ConstId = constId;
    }

    public String getRiskInformation() {
        return RiskInformation;
    }

    public void setRiskInformation(String riskInformation) {
        RiskInformation = riskInformation;
    }
}
