package cn.com.duiba.customer.link.project.api.remoteservice.app91783;

import cn.com.duiba.customer.link.project.api.remoteservice.app91783.req.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app91783.resp.*;

public interface RemoteXiShangService {
    /**
     * 查询openid绑定的锡商用户Id
     *
     * @param wxOpenid
     * @return
     */
    public String queryWxBindXsUserId(String wxOpenid);

    /**
     * 获取短信验证码
     *
     * @param smsCodeReq
     * @return
     */
    public SmsCodeRsp getSmsCodeDB(SmsCodeReq smsCodeReq);

    /**
     * 获取图形验证码
     *
     * @param imgCodeReq
     * @return
     */
    public ImgCodeRsp getImgCodeDB(ImgCodeReq imgCodeReq);

    /**
     * 微信手机号短信注册登陆并生成免登链接(以锡商userId登陆)
     *
     * @param xsWxRegisLoginReq
     * @return
     */
    public WxAutoLoginRsp wxAutoRegisLogin(XsWxRegisLoginReq xsWxRegisLoginReq);

    /**
     * 微信查询登陆状态并生成免登陆链接(以锡商userId登陆)
     *
     * @param xsWxLoginReq
     * @return
     */
    public WxAutoLoginRsp wxQueryLoginStatusAndGetLoginUrl(XsWxLoginReq xsWxLoginReq);

    /**
     * 发放锡币
     *
     * @param imgCodeReq
     * @return
     */
    public SendXsCoinRsp sendXsCoinDB(SendXsCoinReq imgCodeReq);

    /**
     * 查询锡币发放结果
     *
     * @param queryXsCoinReq
     * @return 交易状态：01 该笔交易已成功 02 该笔交易未成功
     */
    public SendResultVO getSendResult(QueryXsCoinReq queryXsCoinReq);

    /**
     * 推送助力绑定关系
     *
     * @param inviteBindReq
     * @return
     */
    public CommonResDTO pushRelationDB(InviteBindReq inviteBindReq);

    /**
     * 推送抽奖结果
     *
     * @param drawRecordReq
     * @return
     */
    CommonResDTO pushRewardDB(DrawRecordReq drawRecordReq);

}
