package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.alibaba.fastjson.JSONObject;

/**
 * QQ活动分析报表数据保存响应DTO
 * 服务代码: QQMiniAPPService.SaveActData
 *
 * @author zhangdaqing
 * @date 2025/10/11
 */
public class QQActDataSaveResponse {

    /**
     * 返回状态码
     * Return>0: 接收成功，值为行数
     * Return<=0: 接收失败
     */
    private final int Return;

    /**
     * 响应结果
     * 例如：success
     */
    private final String Result;

    /**
     * 构造函数
     *
     * @param Return 返回状态码
     * @param Result 响应结果
     */
    public QQActDataSaveResponse(int Return, String Result) {
        this.Return = Return;
        this.Result = Result;
    }

    /**
     * Getter方法
     */
    public int getReturn() {
        return Return;
    }

    public String getResult() {
        return Result;
    }

    /**
     * 判断是否成功
     * Return > 0 表示接收成功
     */
    public boolean isSuccess() {
        return Return > 0;
    }

    /**
     * 获取接收的行数
     */
    public int getReceivedRowCount() {
        return isSuccess() ? Return : 0;
    }

    /**
     * 从JSON字符串创建响应对象
     *
     * @param jsonString JSON字符串
     * @return 响应对象
     */
    public static QQActDataSaveResponse fromJsonString(String jsonString) {
        try {
            JSONObject json = JSONObject.parseObject(jsonString);
            int returnCode = json.getIntValue("Return");
            String result = json.getString("Result");
            return new QQActDataSaveResponse(returnCode, result);
        } catch (Exception e) {
            throw new IllegalArgumentException("无效的响应JSON格式: " + jsonString, e);
        }
    }

    @Override
    public String toString() {
        return "QQActDataSaveResponse{" +
                "Return=" + Return +
                ", Result='" + Result + '\'' +
                '}';
    }
}

