package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.alibaba.fastjson.JSONObject;

/**
 * QQ小程序中奖订单新增响应
 * 
 * @author zhangdaqing
 * @date 2025/9/20 18:30
 */
public class QQAwardOrderAddResponse {
    
    private final int Return;
    private final String Result;
    
    /**
     * 构造函数
     */
    public QQAwardOrderAddResponse(int Return, String Result) {
        this.Return = Return;
        this.Result = Result;
    }
    
    // Getter方法
    public int getReturn() { return Return; }
    public String getResult() { return Result; }
    
    /**
     * 判断是否成功
     * Return>0: 成功, 值为订单ID; Return<0: 失败
     */
    public boolean isSuccess() {
        return Return > 0;
    }
    
    /**
     * 判断是否失败
     */
    public boolean isFailure() {
        return Return < 0;
    }
    
    /**
     * 获取订单ID（成功时返回）
     */
    public String getOrderId() {
        if (isSuccess()) {
            return String.valueOf(Return);
        }
        return null;
    }
    
    /**
     * 获取错误信息（失败时返回）
     */
    public String getErrorMessage() {
        if (isFailure()) {
            return Result != null ? Result : "订单新增失败";
        }
        return null;
    }
    
    /**
     * 从JSON字符串创建响应对象
     */
    public static QQAwardOrderAddResponse fromJsonString(String jsonString) {
        try {
            JSONObject json = JSONObject.parseObject(jsonString);
            int returnCode = json.getIntValue("Return");
            String result = json.getString("Result");
            return new QQAwardOrderAddResponse(returnCode, result);
        } catch (Exception e) {
            throw new IllegalArgumentException("无效的响应JSON格式: " + jsonString, e);
        }
    }
    
    @Override
    public String toString() {
        return "QQAwardOrderAddResponse{" +
                "Return=" + Return +
                ", Result='" + Result + '\'' +
                ", isSuccess=" + isSuccess() +
                ", orderId='" + getOrderId() + '\'' +
                '}';
    }
}
