package cn.com.duiba.customer.link.project.api.remoteservice.app70398.vo;

import com.alibaba.fastjson.annotation.JSONField;

/**
 * @author LiJiang
 * @description 查询用户信息返回类
 * @date 2022/11/21
 * ["{\"RETCODE\":\"AAAAAAA\",\"RETMSG\":\"\",\"OPENID\":\"b9f5b2098138054d4f48ade934a6b151b93c0c797093d2012803cb0b777230f1\",
 * \"CSTNAME\":\"\",\"LGNMOBILE\":\"\",\"CTFTYPE\":\"\",\"CTFNO\":\"\",\"MOBILE\":\"\",\"HOSTCSTNO\":\"001260430824\",
 * \"WALLETID\":\"\",\"CSTNO\":\"3002567011\",\"DATA\":\"\"}"]
 **/
public class CiticCustomerQueryResultVO extends CiticCustomerBaseResultVO{
    /**
     * 返回信息
     */
    @JSONField(name = "RETMSG")
    private String retMsg;

    /**
     * 客户标识 openID+cstno的SM3形式
     */
    @JSONField(name = "OPENID")
    private String openId;

    /**
     * 客户姓名
     */
    @JSONField(name = "CSTNAME")
    private String customerName;

    /**
     * 手机号
     */
    @JSONField(name = "LGNMOBILE")
    private String loginMobile;

    /**
     * 证件类型
     */
    @JSONField(name = "CTFTYPE")
    private String certificateType;

    /**
     * 证件号码
     */
    @JSONField(name = "CTFNO")
    private String certificateNum;

    /**
     * 其他数据 以json形式返回
     */
    @JSONField(name = "DATA")
    private String data;

    /**
     * 核心客户号
     */
    @JSONField(name = "HOSTCSTNO")
    private String hostCstNo;

    public String getHostCstNo() {
        return hostCstNo;
    }

    public void setHostCstNo(String hostCstNo) {
        this.hostCstNo = hostCstNo;
    }

    public String getRetMsg() {
        return retMsg;
    }

    public void setRetMsg(String retMsg) {
        this.retMsg = retMsg;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getCustomerName() {
        return customerName;
    }

    public void setCustomerName(String customerName) {
        this.customerName = customerName;
    }

    public String getLoginMobile() {
        return loginMobile;
    }

    public void setLoginMobile(String loginMobile) {
        this.loginMobile = loginMobile;
    }

    public String getCertificateType() {
        return certificateType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public String getCertificateNum() {
        return certificateNum;
    }

    public void setCertificateNum(String certificateNum) {
        this.certificateNum = certificateNum;
    }

    public String getData() {
        return data;
    }

    public void setData(String data) {
        this.data = data;
    }
}
