package cn.com.duiba.customer.link.project.api.remoteservice.app81279.remote;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.result.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.dto.resultData.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app81279.vo.ZyrsUserInfoVO;
import cn.com.duiba.customer.link.project.common.annotation.SendPrize;

/**
 * Description:
 * <p> 中意人寿三方服务
 * date: 2022/11/1 13:41
 *
 * @author huakai
 */
public interface RemoteZyrsService {
    /**
     * 保存访问记录
     * @param recordData 参与数据
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto saveJoinRecord(ZyrsSaveRecordDataDto recordData) throws BizException;

    /**
     * 保存客户信息
     * @param clientData 客户信息
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto saveUserMessage(ZyrsSaveClientDataDto clientData) throws BizException;

    /**
     * 保存中奖记录
     * @param prizeData 发奖数据
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto savePrizeRecord(ZrysSavePrizeDataDto prizeData) throws BizException;

    /**
     * 查询是否关注公众号
     * @param openId 用户openId
     * @return data  0 未关注 1 已关注
     * @throws BizException 业务异常
     */
    ZyrsResultDto isFocus(String openId) throws BizException;

    /**
     * 查询任务
     * @param clientNo 客户号
     * @return 任务信息
     * @throws BizException 业务异常
     */
    ZyrsTaskResultDto queryTask(String clientNo) throws BizException;

    /**
     * 查询客户号
     * @param mobile 手机号
     * @return 客户号
     * @throws BizException 业务异常
     */
    ZyrsClientNoResultDto getClientNo(String mobile) throws BizException;

    /**
     * 获取头像昵称
     * @return
     */
    ZyrsUserInfoVO getUserInfo(String openId);

    /**
     * 判断该笔校验是否填写地址
     * @param projectxRecordId 星速台项目ID
     * @return true 已填写地址 false 未填写地址
     */
    boolean orderHadAddress(String projectxRecordId);


    /**
     * 用户信息同步
     * @param syncDataDto 同步数据参数
     * @return
     * @throws BizException
     */
    ZyrsResultDto userInfoSync(ZyrsUserInfoSyncDataDto syncDataDto) throws BizException;

    /**
     * 加积分
     */
    @SendPrize(value = "orderNum")
    boolean addCredits(ZyrsAddCreditsDto addCreditsDto) throws BizException;

    /**
     * 通过手机号获取uid
     * @param phoneNumber 手机号
     * @return uid
     * @throws BizException 异常
     */
    ZyrsGetCustomerResponse getCustomerId(String phoneNumber) throws BizException;

    /**
     * 发放三选一奖品
     * @param zyrsSendPrizeDto
     * @return
     */
    @SendPrize(value = "orderNo")
    boolean sendThirdPrize(ZyrsSendPrizeDto zyrsSendPrizeDto) throws BizException;


    /**
     * 根据unionId查询关注官微的用户的昵称/头像/是否关注
     */
    ZyrsUserDataDto getUserData(ZyrsGetUserDataDto dto) throws BizException;

    /**
     * 根据手代理人工号查询代理人执业证相关信息
     * @return
     */
    ZyrsAgentInfoDto getAgentInfo(ZyrsGetAgentInfoDto dto) throws BizException;

    /**
     * 通过customerId查询用户信息
     * @return
     */
    ZyrsUserInfoDto getUserInfoByCustomerId(ZrysGetUserInfoDto dto) throws BizException;

    /**
     * 获取代理人客户类型
     */
    ZyrsAgentCustomTypeDto getAgentCustomerType(ZyrsGetAgentCustomDto dto) throws BizException;


    /**
     * 扣积分
     */
    @SendPrize(value = "orderNum")
    boolean subCredits(ZyrsSubCreditsDto subCreditsDto) throws BizException;

    /**
     * 每日5000步加积分
     * @param zyrsTaskCompleteRequest 请求参数
     * @return 响应参数
     */
    ZyrsTaskCompleteNotifyDto notifyStepForFiveTaskComplete(ZyrsTaskCompleteRequest zyrsTaskCompleteRequest) throws BizException;

    /**
     * 查询添加企微状态
     *
     * @param dto dto
     * @return 响应参数
     */
    ZyrsCommonResponseDto<AddWechatStatusObjectVo> queryAddWechatStatus(ZysrAddWechatStatusRequestDto dto) throws BizException;

    /**
     * 查询添加企微二维码
     *
     * @param dto dto
     * @return 响应参数
     */
    ZyrsCommonResponseDto<ZyrsAddWechatQrCodeResultDto> queryAddWechatQrCodeResult(ZyrsAddWechatQrCoeRequestDto dto) throws BizException;

    /**
     * 发送动态
     * @param messageDynamicDto 发奖数据
     * @return data null 无意义
     * @throws BizException 业务异常
     */
    ZyrsResultDto sendMessageDynamic(ZrysMessageDynamicDto messageDynamicDto) throws BizException;

}
