package cn.com.duiba.customer.link.project.api.remoteservice.app93842;

import cn.com.duiba.customer.link.project.api.remoteservice.app93842.dto.*;
import cn.com.duiba.customer.link.project.api.remoteservice.app93842.vo.*;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.Map;

/**
 * 太平洋保险第三方服务
 */
public interface RemoteTaiBaoService {
    /**
     * 外部数据接入接口
     *
     * @param thirdDataDto
     * @return
     */
    ThirdDataVO thirdData(ThirdDataDto thirdDataDto);

    /**
     * 赠送险查询接口
     *
     * @param uid 开发者ID
     * @return true 已领取赠险 false 未领取赠险
     */
    boolean giftInsuranceQuery(String uid);

    /**
     * 查询业务员编号
     *
     * @param uid 开发者ID
     * @return
     */
    AgentVO queryAgent(String uid);

    /**
     * NPS接口
     *
     * @param npsRequestDto 请求参数
     * @return {@link NpsReturnVO}
     */
    NpsReturnVO nps(NpsRequestDto npsRequestDto);

    /**
     * 鉴权获取业务员信息
     *
     * @param dto 请求参数
     * @return 业务员信息
     */
    AuthenticationReturnVO getAuthentication(AuthenticationReqDto dto);

    /**
     * 生成跳转太好店a端太阳码
     *
     * @param dto 请求参数
     * @return 太好店a端太阳码base64
     */
    GenerateQrCodeReturnVO generateQrCode(GenerateQrCodeReqDto dto);

    /**
     * 根据OPENID查询用户年度报告
     *
     * @param openId - 用户OPENID
     * @return {@link ReportEntityVO}
     */
    ReportEntityVO getReport(String openId);

    /**
     * 根据EMPNO查询业务员年度报告
     *
     * @param empNo - 代理人工号
     * @return {@link ReportRespVO}
     */
    EmpReportEntityVO getEmpReport(String empNo);

    /**
     * 获取视频直播数据信息
     *
     * @param todayTime 当天日期
     * @param unionId   unionId
     * @return ProcessDataVO
     */
    Map<String, ProcessDataVO> getProcess(String todayTime, String unionId);

    String getAIContent(AIContentDto content);


    /**
     * 视频人脸融合
     *
     * @param dto
     * @return
     */
    VideoFaceFusionVO videoFaceFusion(@RequestBody VideoFaceFusionDto dto);

    DeleteRabbitTokenVO videoFaceFusion(@RequestBody DeleteRabbitTokenDto dto);

    /**
     * 官微-第三方获取用户信息
     *
     * @param token       官微传过来的，gwAuthToken
     * @param src         系统来源，客户分配
     * @param environment test/prod,不传默认为prod
     * @return 用户信息
     */
    UserInfoDto gwGetUserInfo(String token, String src, String environment);

    /**
     * 获取官微授权地址token
     *
     * @param phone   手机号
     * @param unionId unionId
     * @return 官微授权地址token
     */
    GwResult<String> getGwAuthToken(String phone, String unionId, String environment);

    /**
     * 官微增加宝贝值
     *
     * @param dto dto
     * @return 为true成功
     */
    boolean gwAddCredits(GwAddCreditsDto dto);

    /**
     * 消耗宝贝值
     */
    boolean consumeCredits(ConsumeCreditsDto dto);

    /**
     * 查询剩余保贝值
     */
    Long queryCredits(QueryCreditsDto dto);

    /**
     * 官微-查询是否为黑名单用户
     *
     * @param dto dto
     * @return 命中则反参Y；均为未命中则反参N
     */
    String queryRiskResult(QueryWhiteParamDto dto);

    /**
     * 推送活动数据
     *
     * @param dto dto
     * @return 为true成功
     */
    boolean retainCapitalData(RetainCapitalParamDto dto);

    /**
     * 保存活动领奖信息
     *
     * @param dto dto
     * @return 结果
     */
    SaveResultReturnVO<SaveResultDataVO> saveActivityReceive(SaveActivityReceiveReqDto dto);

    /**
     * 保存活动授权信息
     *
     * @param dto dto
     * @return 结果
     */
    SaveResultReturnVO<SaveResultDataVO> saveAuth(SaveAuthReqDto dto);

    /**
     * 保存活动用户行为
     *
     * @param dto dto
     * @return 结果
     */
    SaveResultReturnVO<SaveResultDataVO> saveUserAction(SaveUserActionReqDto dto);

    /**
     * 保存活动身份信息
     *
     * @param dto dto
     * @return 结果
     */
    SaveResultReturnVO<SaveResultDataVO> saveUserIdentity(SaveUserIdentityReqDto dto);

    /**
     * 年鉴活动参与通知 true-成功 false-失败
     */
    Boolean saveYearReportJoinNotify(SaveYearReportNotifyReqDto dto);

    /**
     * 年鉴活动中奖通知 true-成功 false-失败
     */
    Boolean saveYearReportAwardNotify(SaveYearReportAwardNotifyReqDto dto);

}
