package cn.com.duiba.customer.link.project.api.remoteservice.app98899;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.customer.link.project.api.remoteservice.app98899.param.GetLoginUserResponse;
import cn.com.duiba.customer.link.project.api.remoteservice.app98899.param.OrderListParam;

import java.util.List;

/**
 * @descriptions: 超威
 * @author: Wei Yi Ye
 * @date: 2025/5/16 11:07
 * @version: 1.0
 */
public interface RemoteChaoWeiService {

    /**
     * 发送添加抽奖机会请求
     *
     * @param loginId 用户uid
     * @param env     env 环境(test测试  prod生产)
     * @return true 成功 false 失败
     */
    boolean addLottery(Integer loginId, String env) throws BizException;

    /**
     * 用户订单列表
     *
     * @param param 入参
     * @return 已支付订单数量
     */
    Integer orderNumByUser(OrderListParam param) throws BizException;

    /**
     * 获取用户信息
     *
     * @param loginId 用户uid
     * @param env     环境(test测试  prod生产)
     * @return 用户信息
     * @throws BizException
     */
    GetLoginUserResponse getLoginUser(Integer loginId, String env) throws BizException;
}
