package cn.com.duiba.customer.link.project.api.remoteservice.app86018.vo;

import com.alibaba.fastjson.annotation.JSONField;

import java.util.List;

/**
 * @author LiJiang
 * @description 查询任务调用三方接口参数类
 * @date 2022/11/29
 */
public class QueryTaskParam {
    /**
     * 固定填QPQ21V01
     */
    @JSONField(name = "PRCCOD")
    private String prcCode="QPQ21V01";
    /**
     * 发起方系统日期（YYYYMMDD）
     */
    @JSONField(name = "ISUDAT")
    private String isuDat;
    /**
     * 发起方系统日期（HHMMSS）
     */
    @JSONField(name = "ISUTIM")
    private String isuTim;
    /**
     * 作业条数据部分
     */
    @JSONField(name = "INFBDY")
    private InfBDy infBDy;

    public String getPrcCode() {
        return prcCode;
    }

    public void setPrcCode(String prcCode) {
        this.prcCode = prcCode;
    }

    public String getIsuDat() {
        return isuDat;
    }

    public void setIsuDat(String isuDat) {
        this.isuDat = isuDat;
    }

    public String getIsuTim() {
        return isuTim;
    }

    public void setIsuTim(String isuTim) {
        this.isuTim = isuTim;
    }

    public InfBDy getInfBDy() {
        return infBDy;
    }

    public void setInfBDy(InfBDy infBDy) {
        this.infBDy = infBDy;

    }

    public static class InfBDy {
        /**
         * 固定填QPQ21V01X1
         */
        @JSONField(name = "QPQ21V01X1")
        private List<QPQ21V01X1> qpq21V01X1;

        public List<QPQ21V01X1> getQpq21V01X1() {
            return qpq21V01X1;
        }

        public void setQpq21V01X1(List<QPQ21V01X1> qpq21V01X1) {
            this.qpq21V01X1 = qpq21V01X1;
        }
    }

    public static class QPQ21V01X1 {
        /**
         * 用户id
         */
        @JSONField(name = "UNI_USER_ID")
        private String uniUserId;
        /**
         * 	资格ID，QRY_TYP=G时，置空；
         * 	QRY_TYP=Q时，非空，可以传多个资格ID的列表，英文半角逗号分隔；
         * 	QRY_TYP=D时，非空，且输入为门槛资格ID的列表，英文半角逗号分隔
         */
        @JSONField(name = "QUA_ID")
        private String quaId;
        /**
         * 机构号，固定填KMDBRWHB
         */
        @JSONField(name = "QRY_ORG")
        private String qryOrg="KMDBRWHB";
        /**
         * G：按资格组,Q：按资格,D：门槛资格查询(查询类型为D时，只有Z2返回)
         */
        @JSONField(name = "QRY_TYP")
        private String qryTyp="Q";
        /**
         * 06:行外;09:微信小程序
         */
        @JSONField(name = "QRY_CHN")
        private String qryChn="06";

        public String getUniUserId() {
            return uniUserId;
        }

        public void setUniUserId(String uniUserId) {
            this.uniUserId = uniUserId;
        }

        public String getQuaId() {
            return quaId;
        }

        public void setQuaId(String quaId) {
            this.quaId = quaId;
        }

        public String getQryOrg() {
            return qryOrg;
        }

        public void setQryOrg(String qryOrg) {
            this.qryOrg = qryOrg;
        }

        public String getQryTyp() {
            return qryTyp;
        }

        public void setQryTyp(String qryTyp) {
            this.qryTyp = qryTyp;
        }

        public String getQryChn() {
            return qryChn;
        }

        public void setQryChn(String qryChn) {
            this.qryChn = qryChn;
        }
    }

}
