package cn.com.duiba.customer.link.project.api.remoteservice.app89569.vo;

/**
 * @program: customer-link-project
 * @description: 活动信息同步
 * @author: fenghuohuo
 * @create: 2023-03-06 13:59
 **/
public class ActivityInfoSynchronizationReq {
    /**
     * 活动编号 唯一且不可变 星速台项目id
     */
    private String activityNo;

    /**
     * 活动类型 默认值：game
     */
    private String activityType;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 活动开始时间 格式：YYYY-MM-DD HH:mm:s
     */
    private String startTime;

    /**
     * 活动结束时间 格式：YYYY-MM-DD HH:mm:s
     */
    private String endTime;

    /**
     * 启用状态 0：未启用；1：已启用；2：已结束；
     */
    private String status;

    /**
     * 删除标识 F：未删除；T已删除
     */
    private String delStatus;

    /**
     * 发红包活动编号，活动内有红包则该字段必传
     */
    private String redPackageNo;

    /**
     * 发红包结果回调，活动内有红包则该字段必传
     */
    private String paymentResultUrl;

    /**
     * 发红包最终结果回调，活动内有红包则该字段必传
     */
    private String finalResultUrl;


    /**
     * 品牌标识(口味王：kww、和成天下：hctx)
     */
    private String brandCode;

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

    public String getActivityNo() {
        return activityNo;
    }

    public ActivityInfoSynchronizationReq setActivityNo(String activityNo) {
        this.activityNo = activityNo;
        return this;
    }

    public String getActivityType() {
        return activityType;
    }

    public ActivityInfoSynchronizationReq setActivityType(String activityType) {
        this.activityType = activityType;
        return this;
    }

    public String getActivityName() {
        return activityName;
    }

    public ActivityInfoSynchronizationReq setActivityName(String activityName) {
        this.activityName = activityName;
        return this;
    }

    public String getStartTime() {
        return startTime;
    }

    public ActivityInfoSynchronizationReq setStartTime(String startTime) {
        this.startTime = startTime;
        return this;
    }

    public String getEndTime() {
        return endTime;
    }

    public ActivityInfoSynchronizationReq setEndTime(String endTime) {
        this.endTime = endTime;
        return this;
    }

    public String getStatus() {
        return status;
    }

    public ActivityInfoSynchronizationReq setStatus(String status) {
        this.status = status;
        return this;
    }

    public String getDelStatus() {
        return delStatus;
    }

    public ActivityInfoSynchronizationReq setDelStatus(String delStatus) {
        this.delStatus = delStatus;
        return this;
    }

    public String getRedPackageNo() {
        return redPackageNo;
    }

    public void setRedPackageNo(String redPackageNo) {
        this.redPackageNo = redPackageNo;
    }

    public String getPaymentResultUrl() {
        return paymentResultUrl;
    }

    public void setPaymentResultUrl(String paymentResultUrl) {
        this.paymentResultUrl = paymentResultUrl;
    }

    public String getFinalResultUrl() {
        return finalResultUrl;
    }

    public void setFinalResultUrl(String finalResultUrl) {
        this.finalResultUrl = finalResultUrl;
    }
}
