package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotNull;

/**
 * QQ宝宝信息查询请求DTO
 * 用于检查宝宝是否已存在，返回babyId
 *
 * @author zhangdaqing
 * @date 2025/10/10
 */
public class QQBabyCheckRequest {

    /**
     * 宝宝名称
     */
    @JsonProperty("babyName")
    @NotNull(message = "宝宝名称不能为空")
    private String babyName;

    /**
     * 性别，0男1女
     */
    @JsonProperty("gender")
    @NotNull(message = "性别不能为空")
    private Integer gender;

    /**
     * 生日时间戳13位
     */
    @JsonProperty("birthday")
    @NotNull(message = "生日不能为空")
    private Long birthday;

    /**
     * 用户unionId（用于获取accessToken）
     */
    @JsonProperty("unionId")
    @NotNull(message = "unionId不能为空")
    private String unionId;

    public QQBabyCheckRequest() {
    }

    public QQBabyCheckRequest(String babyName, Integer gender, Long birthday, String unionId) {
        this.babyName = babyName;
        this.gender = gender;
        this.birthday = birthday;
        this.unionId = unionId;
    }

    public String getBabyName() {
        return babyName;
    }

    public void setBabyName(String babyName) {
        this.babyName = babyName;
    }

    public Integer getGender() {
        return gender;
    }

    public void setGender(Integer gender) {
        this.gender = gender;
    }

    public Long getBirthday() {
        return birthday;
    }

    public void setBirthday(Long birthday) {
        this.birthday = birthday;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    @Override
    public String toString() {
        return "QQBabyCheckRequest{" +
                "babyName='" + babyName + '\'' +
                ", gender=" + gender +
                ", birthday=" + birthday +
                ", unionId='" + unionId + '\'' +
                '}';
    }
}

