package cn.com.duiba.customer.link.project.api.remoteservice.app99349.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * QQ活动分析报表行数据DTO
 * 表示TableRowData数组中的单个数据行
 *
 * @author zhangdaqing
 * @date 2025/10/11
 */
public class QQTableRowData implements Serializable {

    /**
     * 主键ID
     * 说明：存储记录的唯一标识，如订单ID、记录ID等
     * 例如：point_001, order_123, change_456
     */
    @JsonProperty("Key")
    @NotBlank(message = "Key不能为空")
    private String key;

    /**
     * 字段值（分号分隔）
     * 说明：存储除主键外的所有字段值，多个字段值之间用分号(;)分隔
     * 
     * 示例1（3个字段：name, time）：
     * "张三;2025-10-11 10:00:00"
     * 
     * 示例2（7个字段：guid, changeTime, point, source, awardTime, giftName, giftCode）：
     * "9665B17E-6777-46D3-9A51-011F09CD2B25;2025-10-11 10:00:00;100;积分扫码;2025-10-11 10:05:00;QQ星奶粉;GIFT001"
     * 
     * 示例3（包含嵌套信息，内部用竖线|分隔）：
     * "9665B17E...;2025-10-11 12:00:00;GIFT003;2;张三|13800138000|上海市浦东新区"
     */
    @JsonProperty("Value")
    @NotBlank(message = "Value不能为空")
    private String value;

    /**
     * 无参构造函数
     */
    public QQTableRowData() {
    }

    /**
     * 全参构造函数
     *
     * @param key   主键ID
     * @param value 字段值（分号分隔）
     */
    public QQTableRowData(String key, String value) {
        this.key = key;
        this.value = value;
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getValue() {
        return value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return "QQTableRowData{" +
                "key='" + key + '\'' +
                ", value='" + value + '\'' +
                '}';
    }
}

