package cn.com.duiba.customer.link.project.api.remoteservice.appisv1.adaptor;

import cn.com.duiba.projectx.sdk.BizRuntimeException;
import cn.com.duiba.projectx.sdk.MQConsumerApi;
import cn.com.duiba.projectx.sdk.TimerApi;
import cn.com.duiba.projectx.sdk.UserRequestApi;
import cn.com.duiba.projectx.sdk.template.DistributedLock;
import cn.com.duiba.projectx.sdk.transaction.ProjectTransactionApi;
import cn.com.duiba.projectx.sdk.utils.ConsumerApi;
import cn.com.duiba.projectx.sdk.utils.ConsumerCreditApi;
import cn.com.duiba.projectx.sdk.utils.DuibaApi;
import cn.com.duiba.projectx.sdk.utils.HttpHelper;
import cn.com.duiba.projectx.sdk.utils.KeyValueApi;
import cn.com.duiba.projectx.sdk.utils.NotifyApi;
import cn.com.duiba.projectx.sdk.utils.QueryTableSp;
import cn.com.duiba.projectx.sdk.utils.RedisApi;
import cn.hutool.core.date.DateUtil;

import java.util.Date;

/**
 * write_your_class_description_here
 *
 * @author xulei
 * @since 1.0.0
 */
public class IsvApiAdaptor {

    public static Date getDateVariable(Object api, String key) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getDateVariable(key);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getDateVariable(key);
        }
        if (api instanceof MQConsumerApi) {
            String config = ((MQConsumerApi) api).getStringVariable(key);
            return DateUtil.parse(config);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static String getStringVariable(Object api, String key) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getStringVariable(key);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getStringVariable(key);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getStringVariable(key);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static int getIntVariable(Object api, String key) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getIntVariable(key);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getIntVariable(key);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getIntVariable(key);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static <T> QueryTableSp<T> getQueryTableSp(Object api, Class<T> clazz) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getQueryTableSp(clazz);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getQueryTableSp(clazz);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getQueryTableSp(clazz);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static DistributedLock newLock(Object api, String key, int expireSeconds) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).newLock(key, expireSeconds);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).newLock(key, expireSeconds);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).newLock(key, expireSeconds);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static HttpHelper getHttpHelper(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getProjectApi().getHttpHelper();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getHttpHelper();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getHttpHelper();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static RedisApi getRedisApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getRedisApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getRedisApi();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getRedisApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static NotifyApi getNotifyApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getNotifyApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getNotifyApi();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getNotifyApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static ConsumerApi getConsumerApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getDuibaApi().getConsumerApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getDuibaApi().getConsumerApi();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getDuibaApi().getConsumerApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static KeyValueApi getKeyValueApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getKeyValueApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getKeyValueApi();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getKeyValueApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static ConsumerCreditApi getConsumerCreditApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getDuibaApi().getConsumerCreditApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getDuibaApi().getConsumerCreditApi();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getDuibaApi().getConsumerCreditApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static DuibaApi getDuibaApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getDuibaApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getDuibaApi();
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getDuibaApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static ProjectTransactionApi getTransactionApi(Object api) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getTransactionApi();
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getTransactionApi();
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static long getSomebodyStageProperty(Object api, String userId, String spId) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getProjectApi().getSomebodyStageProperty(userId, spId);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).getSomebodyStageProperty(userId, spId);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).getSomebodyStageProperty(userId, spId);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static boolean consumeSomebodyStageProperty(Object api, String userId, String spId, int quantity) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getProjectApi().consumeStageProperty(userId, spId, quantity);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).consumeStageProperty(userId, spId, quantity);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).consumeStageProperty(userId, spId, quantity);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

    public static Long giveSomebodyStageProperty(Object api, String userId, String spId, int quantity) {
        if (api instanceof UserRequestApi) {
            return ((UserRequestApi) api).getProjectApi().giveStageProperty(userId, spId, quantity);
        }
        if (api instanceof TimerApi) {
            return ((TimerApi) api).giveStageProperty(userId, spId, quantity);
        }
        if (api instanceof MQConsumerApi) {
            return ((MQConsumerApi) api).giveStageProperty(userId, spId, quantity);
        }
        throw new BizRuntimeException("不支持的api类型");
    }

}
