package cn.com.duiba.dayu.api.dto;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;

import cn.com.duiba.dayu.api.utils.ListUtils;

/**
 * Created by lizhihui on 2017-08-07 14:31.
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
public class SceneConfig implements Serializable {

    // 这个id是type=experiment 才有效的
    private Long                id;

    private String              name;

    // 类型,分别为:domain\layer\experiment
    private String              type;

    // 参数集合
    private Map<String, String> arguments;

    // 下层配置列表
    private List<SceneConfig>   configList;

    // 流量比率
    private String              flowRate;

    // 流量切分类型,现在只存在两种consumerId hash 和 deviceId hash
    private Integer             diversion;

    public Integer getDiversion() {
        return diversion;
    }

    public void setDiversion(Integer diversion) {
        this.diversion = diversion;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Map<String, String> getArguments() {
        return arguments;
    }

    public void setArguments(Map<String, String> arguments) {
        this.arguments = arguments;
    }

    public List<SceneConfig> getConfigList() {
        return configList;
    }

    public void setConfigList(List<SceneConfig> configList) {
        this.configList = configList;
    }

    public String getFlowRate() {
        return flowRate;
    }

    public void setFlowRate(String flowRate) {
        this.flowRate = flowRate;
    }

    public SceneConfig() {
    }

    public SceneConfig(SceneConfig sceneConfig) throws IOException, ClassNotFoundException {
        this.id = sceneConfig.id;
        this.name = sceneConfig.name;
        this.type = sceneConfig.type;
        this.arguments = sceneConfig.arguments;
        this.configList = ListUtils.deepCopy(sceneConfig.configList);
        this.flowRate = sceneConfig.flowRate;
        this.diversion = sceneConfig.diversion;
    }
}
