package cn.com.duiba.dayu.api.enums;

/**
 * 流量分割类型 Created by lizhihui on 2017-08-07 17:11.
 */
public enum DiversionTypeEnum {
                               // 用户id hash分割
                               CONSUMER_ID_HASH(1),
                               // 设备id hash分割
                               DEVICE_ID_HASH(2),
                               // 随机
                               RANDOM_HASH(3),
    ;

    private Integer type;

    DiversionTypeEnum(Integer type) {
        this.type = type;
    }

    public Integer getType() {
        return type;
    }

    public static DiversionTypeEnum getType(Integer type) {
        for (DiversionTypeEnum indexType : DiversionTypeEnum.values()) {
            if (indexType.type.equals(type)) {
                return indexType;
            }
        }
        return null;
    }
}
